/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.OAuth2Properties;
import com.amazonaws.services.appflow.model.transform.CustomConnectorProfilePropertiesMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CustomConnectorProfileProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> profileProperties;
    private OAuth2Properties oAuth2Properties;

    public Map<String, String> getProfileProperties() {
        return this.profileProperties;
    }

    public void setProfileProperties(Map<String, String> profileProperties) {
        this.profileProperties = profileProperties;
    }

    public CustomConnectorProfileProperties withProfileProperties(Map<String, String> profileProperties) {
        this.setProfileProperties(profileProperties);
        return this;
    }

    public CustomConnectorProfileProperties addProfilePropertiesEntry(String key, String value) {
        if (null == this.profileProperties) {
            this.profileProperties = new HashMap<String, String>();
        }
        if (this.profileProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.profileProperties.put(key, value);
        return this;
    }

    public CustomConnectorProfileProperties clearProfilePropertiesEntries() {
        this.profileProperties = null;
        return this;
    }

    public void setOAuth2Properties(OAuth2Properties oAuth2Properties) {
        this.oAuth2Properties = oAuth2Properties;
    }

    public OAuth2Properties getOAuth2Properties() {
        return this.oAuth2Properties;
    }

    public CustomConnectorProfileProperties withOAuth2Properties(OAuth2Properties oAuth2Properties) {
        this.setOAuth2Properties(oAuth2Properties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProfileProperties() != null) {
            sb.append("ProfileProperties: ").append(this.getProfileProperties()).append(",");
        }
        if (this.getOAuth2Properties() != null) {
            sb.append("OAuth2Properties: ").append(this.getOAuth2Properties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConnectorProfileProperties)) {
            return false;
        }
        CustomConnectorProfileProperties other = (CustomConnectorProfileProperties)obj;
        if (other.getProfileProperties() == null ^ this.getProfileProperties() == null) {
            return false;
        }
        if (other.getProfileProperties() != null && !other.getProfileProperties().equals(this.getProfileProperties())) {
            return false;
        }
        if (other.getOAuth2Properties() == null ^ this.getOAuth2Properties() == null) {
            return false;
        }
        return other.getOAuth2Properties() == null || other.getOAuth2Properties().equals(this.getOAuth2Properties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProfileProperties() == null ? 0 : this.getProfileProperties().hashCode());
        hashCode = 31 * hashCode + (this.getOAuth2Properties() == null ? 0 : this.getOAuth2Properties().hashCode());
        return hashCode;
    }

    public CustomConnectorProfileProperties clone() {
        try {
            return (CustomConnectorProfileProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomConnectorProfilePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

