/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.transform.EngineConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EngineConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer coordinatorDpuSize;
    private Integer maxConcurrentDpus;
    private Integer defaultExecutorDpuSize;
    private Map<String, String> additionalConfigs;
    private Map<String, String> sparkProperties;

    public void setCoordinatorDpuSize(Integer coordinatorDpuSize) {
        this.coordinatorDpuSize = coordinatorDpuSize;
    }

    public Integer getCoordinatorDpuSize() {
        return this.coordinatorDpuSize;
    }

    public EngineConfiguration withCoordinatorDpuSize(Integer coordinatorDpuSize) {
        this.setCoordinatorDpuSize(coordinatorDpuSize);
        return this;
    }

    public void setMaxConcurrentDpus(Integer maxConcurrentDpus) {
        this.maxConcurrentDpus = maxConcurrentDpus;
    }

    public Integer getMaxConcurrentDpus() {
        return this.maxConcurrentDpus;
    }

    public EngineConfiguration withMaxConcurrentDpus(Integer maxConcurrentDpus) {
        this.setMaxConcurrentDpus(maxConcurrentDpus);
        return this;
    }

    public void setDefaultExecutorDpuSize(Integer defaultExecutorDpuSize) {
        this.defaultExecutorDpuSize = defaultExecutorDpuSize;
    }

    public Integer getDefaultExecutorDpuSize() {
        return this.defaultExecutorDpuSize;
    }

    public EngineConfiguration withDefaultExecutorDpuSize(Integer defaultExecutorDpuSize) {
        this.setDefaultExecutorDpuSize(defaultExecutorDpuSize);
        return this;
    }

    public Map<String, String> getAdditionalConfigs() {
        return this.additionalConfigs;
    }

    public void setAdditionalConfigs(Map<String, String> additionalConfigs) {
        this.additionalConfigs = additionalConfigs;
    }

    public EngineConfiguration withAdditionalConfigs(Map<String, String> additionalConfigs) {
        this.setAdditionalConfigs(additionalConfigs);
        return this;
    }

    public EngineConfiguration addAdditionalConfigsEntry(String key, String value) {
        if (null == this.additionalConfigs) {
            this.additionalConfigs = new HashMap<String, String>();
        }
        if (this.additionalConfigs.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalConfigs.put(key, value);
        return this;
    }

    public EngineConfiguration clearAdditionalConfigsEntries() {
        this.additionalConfigs = null;
        return this;
    }

    public Map<String, String> getSparkProperties() {
        return this.sparkProperties;
    }

    public void setSparkProperties(Map<String, String> sparkProperties) {
        this.sparkProperties = sparkProperties;
    }

    public EngineConfiguration withSparkProperties(Map<String, String> sparkProperties) {
        this.setSparkProperties(sparkProperties);
        return this;
    }

    public EngineConfiguration addSparkPropertiesEntry(String key, String value) {
        if (null == this.sparkProperties) {
            this.sparkProperties = new HashMap<String, String>();
        }
        if (this.sparkProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sparkProperties.put(key, value);
        return this;
    }

    public EngineConfiguration clearSparkPropertiesEntries() {
        this.sparkProperties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCoordinatorDpuSize() != null) {
            sb.append("CoordinatorDpuSize: ").append(this.getCoordinatorDpuSize()).append(",");
        }
        if (this.getMaxConcurrentDpus() != null) {
            sb.append("MaxConcurrentDpus: ").append(this.getMaxConcurrentDpus()).append(",");
        }
        if (this.getDefaultExecutorDpuSize() != null) {
            sb.append("DefaultExecutorDpuSize: ").append(this.getDefaultExecutorDpuSize()).append(",");
        }
        if (this.getAdditionalConfigs() != null) {
            sb.append("AdditionalConfigs: ").append(this.getAdditionalConfigs()).append(",");
        }
        if (this.getSparkProperties() != null) {
            sb.append("SparkProperties: ").append(this.getSparkProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineConfiguration)) {
            return false;
        }
        EngineConfiguration other = (EngineConfiguration)obj;
        if (other.getCoordinatorDpuSize() == null ^ this.getCoordinatorDpuSize() == null) {
            return false;
        }
        if (other.getCoordinatorDpuSize() != null && !other.getCoordinatorDpuSize().equals(this.getCoordinatorDpuSize())) {
            return false;
        }
        if (other.getMaxConcurrentDpus() == null ^ this.getMaxConcurrentDpus() == null) {
            return false;
        }
        if (other.getMaxConcurrentDpus() != null && !other.getMaxConcurrentDpus().equals(this.getMaxConcurrentDpus())) {
            return false;
        }
        if (other.getDefaultExecutorDpuSize() == null ^ this.getDefaultExecutorDpuSize() == null) {
            return false;
        }
        if (other.getDefaultExecutorDpuSize() != null && !other.getDefaultExecutorDpuSize().equals(this.getDefaultExecutorDpuSize())) {
            return false;
        }
        if (other.getAdditionalConfigs() == null ^ this.getAdditionalConfigs() == null) {
            return false;
        }
        if (other.getAdditionalConfigs() != null && !other.getAdditionalConfigs().equals(this.getAdditionalConfigs())) {
            return false;
        }
        if (other.getSparkProperties() == null ^ this.getSparkProperties() == null) {
            return false;
        }
        return other.getSparkProperties() == null || other.getSparkProperties().equals(this.getSparkProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCoordinatorDpuSize() == null ? 0 : this.getCoordinatorDpuSize().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrentDpus() == null ? 0 : this.getMaxConcurrentDpus().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultExecutorDpuSize() == null ? 0 : this.getDefaultExecutorDpuSize().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalConfigs() == null ? 0 : this.getAdditionalConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getSparkProperties() == null ? 0 : this.getSparkProperties().hashCode());
        return hashCode;
    }

    public EngineConfiguration clone() {
        try {
            return (EngineConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EngineConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

