/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.ExecutePolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ExecutePolicyRequestMarshaller
implements Marshaller<Request<ExecutePolicyRequest>, ExecutePolicyRequest> {
    public Request<ExecutePolicyRequest> marshall(ExecutePolicyRequest executePolicyRequest) {
        if (executePolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)executePolicyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "ExecutePolicy");
        request.addParameter("Version", "2011-01-01");
        if (executePolicyRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)executePolicyRequest.getAutoScalingGroupName()));
        }
        if (executePolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)executePolicyRequest.getPolicyName()));
        }
        if (executePolicyRequest.isHonorCooldown() != null) {
            request.addParameter("HonorCooldown", StringUtils.fromBoolean((Boolean)executePolicyRequest.isHonorCooldown()));
        }
        return request;
    }
}

