/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.Condition;
import com.amazonaws.services.backup.model.transform.BackupSelectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BackupSelection
implements Serializable,
Cloneable,
StructuredPojo {
    private String selectionName;
    private String iamRoleArn;
    private List<String> resources;
    private List<Condition> listOfTags;

    public void setSelectionName(String selectionName) {
        this.selectionName = selectionName;
    }

    public String getSelectionName() {
        return this.selectionName;
    }

    public BackupSelection withSelectionName(String selectionName) {
        this.setSelectionName(selectionName);
        return this;
    }

    public void setIamRoleArn(String iamRoleArn) {
        this.iamRoleArn = iamRoleArn;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public BackupSelection withIamRoleArn(String iamRoleArn) {
        this.setIamRoleArn(iamRoleArn);
        return this;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<String>(resources);
    }

    public BackupSelection withResources(String ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<String>(resources.length));
        }
        for (String ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public BackupSelection withResources(Collection<String> resources) {
        this.setResources(resources);
        return this;
    }

    public List<Condition> getListOfTags() {
        return this.listOfTags;
    }

    public void setListOfTags(Collection<Condition> listOfTags) {
        if (listOfTags == null) {
            this.listOfTags = null;
            return;
        }
        this.listOfTags = new ArrayList<Condition>(listOfTags);
    }

    public BackupSelection withListOfTags(Condition ... listOfTags) {
        if (this.listOfTags == null) {
            this.setListOfTags(new ArrayList<Condition>(listOfTags.length));
        }
        for (Condition ele : listOfTags) {
            this.listOfTags.add(ele);
        }
        return this;
    }

    public BackupSelection withListOfTags(Collection<Condition> listOfTags) {
        this.setListOfTags(listOfTags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSelectionName() != null) {
            sb.append("SelectionName: ").append(this.getSelectionName()).append(",");
        }
        if (this.getIamRoleArn() != null) {
            sb.append("IamRoleArn: ").append(this.getIamRoleArn()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getListOfTags() != null) {
            sb.append("ListOfTags: ").append(this.getListOfTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupSelection)) {
            return false;
        }
        BackupSelection other = (BackupSelection)obj;
        if (other.getSelectionName() == null ^ this.getSelectionName() == null) {
            return false;
        }
        if (other.getSelectionName() != null && !other.getSelectionName().equals(this.getSelectionName())) {
            return false;
        }
        if (other.getIamRoleArn() == null ^ this.getIamRoleArn() == null) {
            return false;
        }
        if (other.getIamRoleArn() != null && !other.getIamRoleArn().equals(this.getIamRoleArn())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getListOfTags() == null ^ this.getListOfTags() == null) {
            return false;
        }
        return other.getListOfTags() == null || other.getListOfTags().equals(this.getListOfTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSelectionName() == null ? 0 : this.getSelectionName().hashCode());
        hashCode = 31 * hashCode + (this.getIamRoleArn() == null ? 0 : this.getIamRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getListOfTags() == null ? 0 : this.getListOfTags().hashCode());
        return hashCode;
    }

    public BackupSelection clone() {
        try {
            return (BackupSelection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupSelectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

