/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backup.model.ControlScope;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ControlScopeMarshaller {
    private static final MarshallingInfo<List> COMPLIANCERESOURCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceIds").build();
    private static final MarshallingInfo<List> COMPLIANCERESOURCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceResourceTypes").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final ControlScopeMarshaller instance = new ControlScopeMarshaller();

    public static ControlScopeMarshaller getInstance() {
        return instance;
    }

    public void marshall(ControlScope controlScope, ProtocolMarshaller protocolMarshaller) {
        if (controlScope == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(controlScope.getComplianceResourceIds(), COMPLIANCERESOURCEIDS_BINDING);
            protocolMarshaller.marshall(controlScope.getComplianceResourceTypes(), COMPLIANCERESOURCETYPES_BINDING);
            protocolMarshaller.marshall(controlScope.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

