/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.batch.model.ContainerProperties;
import com.amazonaws.services.batch.model.JobDefinitionType;
import com.amazonaws.services.batch.model.JobTimeout;
import com.amazonaws.services.batch.model.NodeProperties;
import com.amazonaws.services.batch.model.PlatformCapability;
import com.amazonaws.services.batch.model.RetryStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegisterJobDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String jobDefinitionName;
    private String type;
    private Map<String, String> parameters;
    private ContainerProperties containerProperties;
    private NodeProperties nodeProperties;
    private RetryStrategy retryStrategy;
    private Boolean propagateTags;
    private JobTimeout timeout;
    private Map<String, String> tags;
    private List<String> platformCapabilities;

    public void setJobDefinitionName(String jobDefinitionName) {
        this.jobDefinitionName = jobDefinitionName;
    }

    public String getJobDefinitionName() {
        return this.jobDefinitionName;
    }

    public RegisterJobDefinitionRequest withJobDefinitionName(String jobDefinitionName) {
        this.setJobDefinitionName(jobDefinitionName);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public RegisterJobDefinitionRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(JobDefinitionType type) {
        this.withType(type);
    }

    public RegisterJobDefinitionRequest withType(JobDefinitionType type) {
        this.type = type.toString();
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public RegisterJobDefinitionRequest withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public RegisterJobDefinitionRequest addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public RegisterJobDefinitionRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setContainerProperties(ContainerProperties containerProperties) {
        this.containerProperties = containerProperties;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public RegisterJobDefinitionRequest withContainerProperties(ContainerProperties containerProperties) {
        this.setContainerProperties(containerProperties);
        return this;
    }

    public void setNodeProperties(NodeProperties nodeProperties) {
        this.nodeProperties = nodeProperties;
    }

    public NodeProperties getNodeProperties() {
        return this.nodeProperties;
    }

    public RegisterJobDefinitionRequest withNodeProperties(NodeProperties nodeProperties) {
        this.setNodeProperties(nodeProperties);
        return this;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public RegisterJobDefinitionRequest withRetryStrategy(RetryStrategy retryStrategy) {
        this.setRetryStrategy(retryStrategy);
        return this;
    }

    public void setPropagateTags(Boolean propagateTags) {
        this.propagateTags = propagateTags;
    }

    public Boolean getPropagateTags() {
        return this.propagateTags;
    }

    public RegisterJobDefinitionRequest withPropagateTags(Boolean propagateTags) {
        this.setPropagateTags(propagateTags);
        return this;
    }

    public Boolean isPropagateTags() {
        return this.propagateTags;
    }

    public void setTimeout(JobTimeout timeout) {
        this.timeout = timeout;
    }

    public JobTimeout getTimeout() {
        return this.timeout;
    }

    public RegisterJobDefinitionRequest withTimeout(JobTimeout timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public RegisterJobDefinitionRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public RegisterJobDefinitionRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public RegisterJobDefinitionRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<String> getPlatformCapabilities() {
        return this.platformCapabilities;
    }

    public void setPlatformCapabilities(Collection<String> platformCapabilities) {
        if (platformCapabilities == null) {
            this.platformCapabilities = null;
            return;
        }
        this.platformCapabilities = new ArrayList<String>(platformCapabilities);
    }

    public RegisterJobDefinitionRequest withPlatformCapabilities(String ... platformCapabilities) {
        if (this.platformCapabilities == null) {
            this.setPlatformCapabilities(new ArrayList<String>(platformCapabilities.length));
        }
        for (String ele : platformCapabilities) {
            this.platformCapabilities.add(ele);
        }
        return this;
    }

    public RegisterJobDefinitionRequest withPlatformCapabilities(Collection<String> platformCapabilities) {
        this.setPlatformCapabilities(platformCapabilities);
        return this;
    }

    public RegisterJobDefinitionRequest withPlatformCapabilities(PlatformCapability ... platformCapabilities) {
        ArrayList<String> platformCapabilitiesCopy = new ArrayList<String>(platformCapabilities.length);
        for (PlatformCapability value : platformCapabilities) {
            platformCapabilitiesCopy.add(value.toString());
        }
        if (this.getPlatformCapabilities() == null) {
            this.setPlatformCapabilities(platformCapabilitiesCopy);
        } else {
            this.getPlatformCapabilities().addAll(platformCapabilitiesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(this.getJobDefinitionName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getContainerProperties() != null) {
            sb.append("ContainerProperties: ").append(this.getContainerProperties()).append(",");
        }
        if (this.getNodeProperties() != null) {
            sb.append("NodeProperties: ").append(this.getNodeProperties()).append(",");
        }
        if (this.getRetryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.getRetryStrategy()).append(",");
        }
        if (this.getPropagateTags() != null) {
            sb.append("PropagateTags: ").append(this.getPropagateTags()).append(",");
        }
        if (this.getTimeout() != null) {
            sb.append("Timeout: ").append(this.getTimeout()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getPlatformCapabilities() != null) {
            sb.append("PlatformCapabilities: ").append(this.getPlatformCapabilities());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionRequest)) {
            return false;
        }
        RegisterJobDefinitionRequest other = (RegisterJobDefinitionRequest)obj;
        if (other.getJobDefinitionName() == null ^ this.getJobDefinitionName() == null) {
            return false;
        }
        if (other.getJobDefinitionName() != null && !other.getJobDefinitionName().equals(this.getJobDefinitionName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getContainerProperties() == null ^ this.getContainerProperties() == null) {
            return false;
        }
        if (other.getContainerProperties() != null && !other.getContainerProperties().equals(this.getContainerProperties())) {
            return false;
        }
        if (other.getNodeProperties() == null ^ this.getNodeProperties() == null) {
            return false;
        }
        if (other.getNodeProperties() != null && !other.getNodeProperties().equals(this.getNodeProperties())) {
            return false;
        }
        if (other.getRetryStrategy() == null ^ this.getRetryStrategy() == null) {
            return false;
        }
        if (other.getRetryStrategy() != null && !other.getRetryStrategy().equals(this.getRetryStrategy())) {
            return false;
        }
        if (other.getPropagateTags() == null ^ this.getPropagateTags() == null) {
            return false;
        }
        if (other.getPropagateTags() != null && !other.getPropagateTags().equals(this.getPropagateTags())) {
            return false;
        }
        if (other.getTimeout() == null ^ this.getTimeout() == null) {
            return false;
        }
        if (other.getTimeout() != null && !other.getTimeout().equals(this.getTimeout())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPlatformCapabilities() == null ^ this.getPlatformCapabilities() == null) {
            return false;
        }
        return other.getPlatformCapabilities() == null || other.getPlatformCapabilities().equals(this.getPlatformCapabilities());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobDefinitionName() == null ? 0 : this.getJobDefinitionName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getContainerProperties() == null ? 0 : this.getContainerProperties().hashCode());
        hashCode = 31 * hashCode + (this.getNodeProperties() == null ? 0 : this.getNodeProperties().hashCode());
        hashCode = 31 * hashCode + (this.getRetryStrategy() == null ? 0 : this.getRetryStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getPropagateTags() == null ? 0 : this.getPropagateTags().hashCode());
        hashCode = 31 * hashCode + (this.getTimeout() == null ? 0 : this.getTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformCapabilities() == null ? 0 : this.getPlatformCapabilities().hashCode());
        return hashCode;
    }

    public RegisterJobDefinitionRequest clone() {
        return (RegisterJobDefinitionRequest)super.clone();
    }
}

