/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.batch.model.ArrayProperties;
import com.amazonaws.services.batch.model.ContainerOverrides;
import com.amazonaws.services.batch.model.JobDependency;
import com.amazonaws.services.batch.model.JobTimeout;
import com.amazonaws.services.batch.model.NodeOverrides;
import com.amazonaws.services.batch.model.RetryStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubmitJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String jobName;
    private String jobQueue;
    private ArrayProperties arrayProperties;
    private List<JobDependency> dependsOn;
    private String jobDefinition;
    private Map<String, String> parameters;
    private ContainerOverrides containerOverrides;
    private NodeOverrides nodeOverrides;
    private RetryStrategy retryStrategy;
    private JobTimeout timeout;
    private Map<String, String> tags;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public SubmitJobRequest withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public void setJobQueue(String jobQueue) {
        this.jobQueue = jobQueue;
    }

    public String getJobQueue() {
        return this.jobQueue;
    }

    public SubmitJobRequest withJobQueue(String jobQueue) {
        this.setJobQueue(jobQueue);
        return this;
    }

    public void setArrayProperties(ArrayProperties arrayProperties) {
        this.arrayProperties = arrayProperties;
    }

    public ArrayProperties getArrayProperties() {
        return this.arrayProperties;
    }

    public SubmitJobRequest withArrayProperties(ArrayProperties arrayProperties) {
        this.setArrayProperties(arrayProperties);
        return this;
    }

    public List<JobDependency> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(Collection<JobDependency> dependsOn) {
        if (dependsOn == null) {
            this.dependsOn = null;
            return;
        }
        this.dependsOn = new ArrayList<JobDependency>(dependsOn);
    }

    public SubmitJobRequest withDependsOn(JobDependency ... dependsOn) {
        if (this.dependsOn == null) {
            this.setDependsOn(new ArrayList<JobDependency>(dependsOn.length));
        }
        for (JobDependency ele : dependsOn) {
            this.dependsOn.add(ele);
        }
        return this;
    }

    public SubmitJobRequest withDependsOn(Collection<JobDependency> dependsOn) {
        this.setDependsOn(dependsOn);
        return this;
    }

    public void setJobDefinition(String jobDefinition) {
        this.jobDefinition = jobDefinition;
    }

    public String getJobDefinition() {
        return this.jobDefinition;
    }

    public SubmitJobRequest withJobDefinition(String jobDefinition) {
        this.setJobDefinition(jobDefinition);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public SubmitJobRequest withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public SubmitJobRequest addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public SubmitJobRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setContainerOverrides(ContainerOverrides containerOverrides) {
        this.containerOverrides = containerOverrides;
    }

    public ContainerOverrides getContainerOverrides() {
        return this.containerOverrides;
    }

    public SubmitJobRequest withContainerOverrides(ContainerOverrides containerOverrides) {
        this.setContainerOverrides(containerOverrides);
        return this;
    }

    public void setNodeOverrides(NodeOverrides nodeOverrides) {
        this.nodeOverrides = nodeOverrides;
    }

    public NodeOverrides getNodeOverrides() {
        return this.nodeOverrides;
    }

    public SubmitJobRequest withNodeOverrides(NodeOverrides nodeOverrides) {
        this.setNodeOverrides(nodeOverrides);
        return this;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public SubmitJobRequest withRetryStrategy(RetryStrategy retryStrategy) {
        this.setRetryStrategy(retryStrategy);
        return this;
    }

    public void setTimeout(JobTimeout timeout) {
        this.timeout = timeout;
    }

    public JobTimeout getTimeout() {
        return this.timeout;
    }

    public SubmitJobRequest withTimeout(JobTimeout timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public SubmitJobRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public SubmitJobRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public SubmitJobRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getJobQueue() != null) {
            sb.append("JobQueue: ").append(this.getJobQueue()).append(",");
        }
        if (this.getArrayProperties() != null) {
            sb.append("ArrayProperties: ").append(this.getArrayProperties()).append(",");
        }
        if (this.getDependsOn() != null) {
            sb.append("DependsOn: ").append(this.getDependsOn()).append(",");
        }
        if (this.getJobDefinition() != null) {
            sb.append("JobDefinition: ").append(this.getJobDefinition()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getContainerOverrides() != null) {
            sb.append("ContainerOverrides: ").append(this.getContainerOverrides()).append(",");
        }
        if (this.getNodeOverrides() != null) {
            sb.append("NodeOverrides: ").append(this.getNodeOverrides()).append(",");
        }
        if (this.getRetryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.getRetryStrategy()).append(",");
        }
        if (this.getTimeout() != null) {
            sb.append("Timeout: ").append(this.getTimeout()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitJobRequest)) {
            return false;
        }
        SubmitJobRequest other = (SubmitJobRequest)obj;
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getJobQueue() == null ^ this.getJobQueue() == null) {
            return false;
        }
        if (other.getJobQueue() != null && !other.getJobQueue().equals(this.getJobQueue())) {
            return false;
        }
        if (other.getArrayProperties() == null ^ this.getArrayProperties() == null) {
            return false;
        }
        if (other.getArrayProperties() != null && !other.getArrayProperties().equals(this.getArrayProperties())) {
            return false;
        }
        if (other.getDependsOn() == null ^ this.getDependsOn() == null) {
            return false;
        }
        if (other.getDependsOn() != null && !other.getDependsOn().equals(this.getDependsOn())) {
            return false;
        }
        if (other.getJobDefinition() == null ^ this.getJobDefinition() == null) {
            return false;
        }
        if (other.getJobDefinition() != null && !other.getJobDefinition().equals(this.getJobDefinition())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getContainerOverrides() == null ^ this.getContainerOverrides() == null) {
            return false;
        }
        if (other.getContainerOverrides() != null && !other.getContainerOverrides().equals(this.getContainerOverrides())) {
            return false;
        }
        if (other.getNodeOverrides() == null ^ this.getNodeOverrides() == null) {
            return false;
        }
        if (other.getNodeOverrides() != null && !other.getNodeOverrides().equals(this.getNodeOverrides())) {
            return false;
        }
        if (other.getRetryStrategy() == null ^ this.getRetryStrategy() == null) {
            return false;
        }
        if (other.getRetryStrategy() != null && !other.getRetryStrategy().equals(this.getRetryStrategy())) {
            return false;
        }
        if (other.getTimeout() == null ^ this.getTimeout() == null) {
            return false;
        }
        if (other.getTimeout() != null && !other.getTimeout().equals(this.getTimeout())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getJobQueue() == null ? 0 : this.getJobQueue().hashCode());
        hashCode = 31 * hashCode + (this.getArrayProperties() == null ? 0 : this.getArrayProperties().hashCode());
        hashCode = 31 * hashCode + (this.getDependsOn() == null ? 0 : this.getDependsOn().hashCode());
        hashCode = 31 * hashCode + (this.getJobDefinition() == null ? 0 : this.getJobDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getContainerOverrides() == null ? 0 : this.getContainerOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getNodeOverrides() == null ? 0 : this.getNodeOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getRetryStrategy() == null ? 0 : this.getRetryStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getTimeout() == null ? 0 : this.getTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public SubmitJobRequest clone() {
        return (SubmitJobRequest)super.clone();
    }
}

