/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.budgets.model.Notification;
import com.amazonaws.services.budgets.model.transform.BudgetNotificationsForAccountMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BudgetNotificationsForAccount
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Notification> notifications;
    private String budgetName;

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(Collection<Notification> notifications) {
        if (notifications == null) {
            this.notifications = null;
            return;
        }
        this.notifications = new ArrayList<Notification>(notifications);
    }

    public BudgetNotificationsForAccount withNotifications(Notification ... notifications) {
        if (this.notifications == null) {
            this.setNotifications(new ArrayList<Notification>(notifications.length));
        }
        for (Notification ele : notifications) {
            this.notifications.add(ele);
        }
        return this;
    }

    public BudgetNotificationsForAccount withNotifications(Collection<Notification> notifications) {
        this.setNotifications(notifications);
        return this;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    public String getBudgetName() {
        return this.budgetName;
    }

    public BudgetNotificationsForAccount withBudgetName(String budgetName) {
        this.setBudgetName(budgetName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNotifications() != null) {
            sb.append("Notifications: ").append(this.getNotifications()).append(",");
        }
        if (this.getBudgetName() != null) {
            sb.append("BudgetName: ").append(this.getBudgetName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetNotificationsForAccount)) {
            return false;
        }
        BudgetNotificationsForAccount other = (BudgetNotificationsForAccount)obj;
        if (other.getNotifications() == null ^ this.getNotifications() == null) {
            return false;
        }
        if (other.getNotifications() != null && !other.getNotifications().equals(this.getNotifications())) {
            return false;
        }
        if (other.getBudgetName() == null ^ this.getBudgetName() == null) {
            return false;
        }
        return other.getBudgetName() == null || other.getBudgetName().equals(this.getBudgetName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNotifications() == null ? 0 : this.getNotifications().hashCode());
        hashCode = 31 * hashCode + (this.getBudgetName() == null ? 0 : this.getBudgetName().hashCode());
        return hashCode;
    }

    public BudgetNotificationsForAccount clone() {
        try {
            return (BudgetNotificationsForAccount)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BudgetNotificationsForAccountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

