/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.budgets.model.ActionSubType;
import com.amazonaws.services.budgets.model.transform.SsmActionDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SsmActionDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String actionSubType;
    private String region;
    private List<String> instanceIds;

    public void setActionSubType(String actionSubType) {
        this.actionSubType = actionSubType;
    }

    public String getActionSubType() {
        return this.actionSubType;
    }

    public SsmActionDefinition withActionSubType(String actionSubType) {
        this.setActionSubType(actionSubType);
        return this;
    }

    public SsmActionDefinition withActionSubType(ActionSubType actionSubType) {
        this.actionSubType = actionSubType.toString();
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public SsmActionDefinition withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        this.instanceIds = new ArrayList<String>(instanceIds);
    }

    public SsmActionDefinition withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.setInstanceIds(new ArrayList<String>(instanceIds.length));
        }
        for (String ele : instanceIds) {
            this.instanceIds.add(ele);
        }
        return this;
    }

    public SsmActionDefinition withInstanceIds(Collection<String> instanceIds) {
        this.setInstanceIds(instanceIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionSubType() != null) {
            sb.append("ActionSubType: ").append(this.getActionSubType()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: ").append(this.getInstanceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmActionDefinition)) {
            return false;
        }
        SsmActionDefinition other = (SsmActionDefinition)obj;
        if (other.getActionSubType() == null ^ this.getActionSubType() == null) {
            return false;
        }
        if (other.getActionSubType() != null && !other.getActionSubType().equals(this.getActionSubType())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        return other.getInstanceIds() == null || other.getInstanceIds().equals(this.getInstanceIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionSubType() == null ? 0 : this.getActionSubType().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        return hashCode;
    }

    public SsmActionDefinition clone() {
        try {
            return (SsmActionDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SsmActionDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

