/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.budgets.model.ResourceTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TagResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceARN;
    private List<ResourceTag> resourceTags;

    public void setResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
    }

    public String getResourceARN() {
        return this.resourceARN;
    }

    public TagResourceRequest withResourceARN(String resourceARN) {
        this.setResourceARN(resourceARN);
        return this;
    }

    public List<ResourceTag> getResourceTags() {
        return this.resourceTags;
    }

    public void setResourceTags(Collection<ResourceTag> resourceTags) {
        if (resourceTags == null) {
            this.resourceTags = null;
            return;
        }
        this.resourceTags = new ArrayList<ResourceTag>(resourceTags);
    }

    public TagResourceRequest withResourceTags(ResourceTag ... resourceTags) {
        if (this.resourceTags == null) {
            this.setResourceTags(new ArrayList<ResourceTag>(resourceTags.length));
        }
        for (ResourceTag ele : resourceTags) {
            this.resourceTags.add(ele);
        }
        return this;
    }

    public TagResourceRequest withResourceTags(Collection<ResourceTag> resourceTags) {
        this.setResourceTags(resourceTags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceARN() != null) {
            sb.append("ResourceARN: ").append(this.getResourceARN()).append(",");
        }
        if (this.getResourceTags() != null) {
            sb.append("ResourceTags: ").append(this.getResourceTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest)obj;
        if (other.getResourceARN() == null ^ this.getResourceARN() == null) {
            return false;
        }
        if (other.getResourceARN() != null && !other.getResourceARN().equals(this.getResourceARN())) {
            return false;
        }
        if (other.getResourceTags() == null ^ this.getResourceTags() == null) {
            return false;
        }
        return other.getResourceTags() == null || other.getResourceTags().equals(this.getResourceTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceARN() == null ? 0 : this.getResourceARN().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTags() == null ? 0 : this.getResourceTags().hashCode());
        return hashCode;
    }

    public TagResourceRequest clone() {
        return (TagResourceRequest)super.clone();
    }
}

