/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.Evaluation;
import com.amazonaws.services.config.model.PutEvaluationsRequest;
import com.amazonaws.services.config.model.transform.EvaluationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class PutEvaluationsRequestMarshaller
implements Marshaller<Request<PutEvaluationsRequest>, PutEvaluationsRequest> {
    public Request<PutEvaluationsRequest> marshall(PutEvaluationsRequest putEvaluationsRequest) {
        if (putEvaluationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putEvaluationsRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.PutEvaluations");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            SdkInternalList evaluationsList = (SdkInternalList)putEvaluationsRequest.getEvaluations();
            if (!evaluationsList.isEmpty() || !evaluationsList.isAutoConstruct()) {
                jsonWriter.key("Evaluations");
                jsonWriter.array();
                for (Evaluation evaluationsListValue : evaluationsList) {
                    if (evaluationsListValue == null) continue;
                    EvaluationJsonMarshaller.getInstance().marshall(evaluationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (putEvaluationsRequest.getResultToken() != null) {
                jsonWriter.key("ResultToken").value((Object)putEvaluationsRequest.getResultToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

