/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeDeliveryChannelStatusRequestMarshaller
implements Marshaller<Request<DescribeDeliveryChannelStatusRequest>, DescribeDeliveryChannelStatusRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeDeliveryChannelStatusRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeDeliveryChannelStatusRequest> marshall(DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) {
        if (describeDeliveryChannelStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDeliveryChannelStatusRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeDeliveryChannelStatus");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList deliveryChannelNamesList = (SdkInternalList)describeDeliveryChannelStatusRequest.getDeliveryChannelNames();
            if (!deliveryChannelNamesList.isEmpty() || !deliveryChannelNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DeliveryChannelNames");
                jsonGenerator.writeStartArray();
                for (String deliveryChannelNamesListValue : deliveryChannelNamesList) {
                    if (deliveryChannelNamesListValue == null) continue;
                    jsonGenerator.writeValue(deliveryChannelNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

