/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datasync.model.transform.RecommendationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Recommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String storageType;
    private Map<String, String> storageConfiguration;
    private String estimatedMonthlyStorageCost;

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public Recommendation withStorageType(String storageType) {
        this.setStorageType(storageType);
        return this;
    }

    public Map<String, String> getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public void setStorageConfiguration(Map<String, String> storageConfiguration) {
        this.storageConfiguration = storageConfiguration;
    }

    public Recommendation withStorageConfiguration(Map<String, String> storageConfiguration) {
        this.setStorageConfiguration(storageConfiguration);
        return this;
    }

    public Recommendation addStorageConfigurationEntry(String key, String value) {
        if (null == this.storageConfiguration) {
            this.storageConfiguration = new HashMap<String, String>();
        }
        if (this.storageConfiguration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.storageConfiguration.put(key, value);
        return this;
    }

    public Recommendation clearStorageConfigurationEntries() {
        this.storageConfiguration = null;
        return this;
    }

    public void setEstimatedMonthlyStorageCost(String estimatedMonthlyStorageCost) {
        this.estimatedMonthlyStorageCost = estimatedMonthlyStorageCost;
    }

    public String getEstimatedMonthlyStorageCost() {
        return this.estimatedMonthlyStorageCost;
    }

    public Recommendation withEstimatedMonthlyStorageCost(String estimatedMonthlyStorageCost) {
        this.setEstimatedMonthlyStorageCost(estimatedMonthlyStorageCost);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStorageType() != null) {
            sb.append("StorageType: ").append(this.getStorageType()).append(",");
        }
        if (this.getStorageConfiguration() != null) {
            sb.append("StorageConfiguration: ").append(this.getStorageConfiguration()).append(",");
        }
        if (this.getEstimatedMonthlyStorageCost() != null) {
            sb.append("EstimatedMonthlyStorageCost: ").append(this.getEstimatedMonthlyStorageCost());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        if (other.getStorageType() == null ^ this.getStorageType() == null) {
            return false;
        }
        if (other.getStorageType() != null && !other.getStorageType().equals(this.getStorageType())) {
            return false;
        }
        if (other.getStorageConfiguration() == null ^ this.getStorageConfiguration() == null) {
            return false;
        }
        if (other.getStorageConfiguration() != null && !other.getStorageConfiguration().equals(this.getStorageConfiguration())) {
            return false;
        }
        if (other.getEstimatedMonthlyStorageCost() == null ^ this.getEstimatedMonthlyStorageCost() == null) {
            return false;
        }
        return other.getEstimatedMonthlyStorageCost() == null || other.getEstimatedMonthlyStorageCost().equals(this.getEstimatedMonthlyStorageCost());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStorageType() == null ? 0 : this.getStorageType().hashCode());
        hashCode = 31 * hashCode + (this.getStorageConfiguration() == null ? 0 : this.getStorageConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getEstimatedMonthlyStorageCost() == null ? 0 : this.getEstimatedMonthlyStorageCost().hashCode());
        return hashCode;
    }

    public Recommendation clone() {
        try {
            return (Recommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

