/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.datasync.model.Ec2Config;
import com.amazonaws.services.datasync.model.TagListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateLocationEfsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String subdirectory;
    private String efsFilesystemArn;
    private Ec2Config ec2Config;
    private List<TagListEntry> tags;

    public void setSubdirectory(String subdirectory) {
        this.subdirectory = subdirectory;
    }

    public String getSubdirectory() {
        return this.subdirectory;
    }

    public CreateLocationEfsRequest withSubdirectory(String subdirectory) {
        this.setSubdirectory(subdirectory);
        return this;
    }

    public void setEfsFilesystemArn(String efsFilesystemArn) {
        this.efsFilesystemArn = efsFilesystemArn;
    }

    public String getEfsFilesystemArn() {
        return this.efsFilesystemArn;
    }

    public CreateLocationEfsRequest withEfsFilesystemArn(String efsFilesystemArn) {
        this.setEfsFilesystemArn(efsFilesystemArn);
        return this;
    }

    public void setEc2Config(Ec2Config ec2Config) {
        this.ec2Config = ec2Config;
    }

    public Ec2Config getEc2Config() {
        return this.ec2Config;
    }

    public CreateLocationEfsRequest withEc2Config(Ec2Config ec2Config) {
        this.setEc2Config(ec2Config);
        return this;
    }

    public List<TagListEntry> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagListEntry> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagListEntry>(tags);
    }

    public CreateLocationEfsRequest withTags(TagListEntry ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<TagListEntry>(tags.length));
        }
        for (TagListEntry ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateLocationEfsRequest withTags(Collection<TagListEntry> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubdirectory() != null) {
            sb.append("Subdirectory: ").append(this.getSubdirectory()).append(",");
        }
        if (this.getEfsFilesystemArn() != null) {
            sb.append("EfsFilesystemArn: ").append(this.getEfsFilesystemArn()).append(",");
        }
        if (this.getEc2Config() != null) {
            sb.append("Ec2Config: ").append(this.getEc2Config()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationEfsRequest)) {
            return false;
        }
        CreateLocationEfsRequest other = (CreateLocationEfsRequest)obj;
        if (other.getSubdirectory() == null ^ this.getSubdirectory() == null) {
            return false;
        }
        if (other.getSubdirectory() != null && !other.getSubdirectory().equals(this.getSubdirectory())) {
            return false;
        }
        if (other.getEfsFilesystemArn() == null ^ this.getEfsFilesystemArn() == null) {
            return false;
        }
        if (other.getEfsFilesystemArn() != null && !other.getEfsFilesystemArn().equals(this.getEfsFilesystemArn())) {
            return false;
        }
        if (other.getEc2Config() == null ^ this.getEc2Config() == null) {
            return false;
        }
        if (other.getEc2Config() != null && !other.getEc2Config().equals(this.getEc2Config())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubdirectory() == null ? 0 : this.getSubdirectory().hashCode());
        hashCode = 31 * hashCode + (this.getEfsFilesystemArn() == null ? 0 : this.getEfsFilesystemArn().hashCode());
        hashCode = 31 * hashCode + (this.getEc2Config() == null ? 0 : this.getEc2Config().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateLocationEfsRequest clone() {
        return (CreateLocationEfsRequest)super.clone();
    }
}

