/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.FileSystemLocation;
import com.amazonaws.services.deadline.model.StorageProfileOperatingSystemFamily;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetStorageProfileForQueueResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String displayName;
    private List<FileSystemLocation> fileSystemLocations;
    private String osFamily;
    private String storageProfileId;

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public GetStorageProfileForQueueResult withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public List<FileSystemLocation> getFileSystemLocations() {
        return this.fileSystemLocations;
    }

    public void setFileSystemLocations(Collection<FileSystemLocation> fileSystemLocations) {
        if (fileSystemLocations == null) {
            this.fileSystemLocations = null;
            return;
        }
        this.fileSystemLocations = new ArrayList<FileSystemLocation>(fileSystemLocations);
    }

    public GetStorageProfileForQueueResult withFileSystemLocations(FileSystemLocation ... fileSystemLocations) {
        if (this.fileSystemLocations == null) {
            this.setFileSystemLocations(new ArrayList<FileSystemLocation>(fileSystemLocations.length));
        }
        for (FileSystemLocation ele : fileSystemLocations) {
            this.fileSystemLocations.add(ele);
        }
        return this;
    }

    public GetStorageProfileForQueueResult withFileSystemLocations(Collection<FileSystemLocation> fileSystemLocations) {
        this.setFileSystemLocations(fileSystemLocations);
        return this;
    }

    public void setOsFamily(String osFamily) {
        this.osFamily = osFamily;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public GetStorageProfileForQueueResult withOsFamily(String osFamily) {
        this.setOsFamily(osFamily);
        return this;
    }

    public GetStorageProfileForQueueResult withOsFamily(StorageProfileOperatingSystemFamily osFamily) {
        this.osFamily = osFamily.toString();
        return this;
    }

    public void setStorageProfileId(String storageProfileId) {
        this.storageProfileId = storageProfileId;
    }

    public String getStorageProfileId() {
        return this.storageProfileId;
    }

    public GetStorageProfileForQueueResult withStorageProfileId(String storageProfileId) {
        this.setStorageProfileId(storageProfileId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getFileSystemLocations() != null) {
            sb.append("FileSystemLocations: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOsFamily() != null) {
            sb.append("OsFamily: ").append(this.getOsFamily()).append(",");
        }
        if (this.getStorageProfileId() != null) {
            sb.append("StorageProfileId: ").append(this.getStorageProfileId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStorageProfileForQueueResult)) {
            return false;
        }
        GetStorageProfileForQueueResult other = (GetStorageProfileForQueueResult)obj;
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getFileSystemLocations() == null ^ this.getFileSystemLocations() == null) {
            return false;
        }
        if (other.getFileSystemLocations() != null && !other.getFileSystemLocations().equals(this.getFileSystemLocations())) {
            return false;
        }
        if (other.getOsFamily() == null ^ this.getOsFamily() == null) {
            return false;
        }
        if (other.getOsFamily() != null && !other.getOsFamily().equals(this.getOsFamily())) {
            return false;
        }
        if (other.getStorageProfileId() == null ^ this.getStorageProfileId() == null) {
            return false;
        }
        return other.getStorageProfileId() == null || other.getStorageProfileId().equals(this.getStorageProfileId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemLocations() == null ? 0 : this.getFileSystemLocations().hashCode());
        hashCode = 31 * hashCode + (this.getOsFamily() == null ? 0 : this.getOsFamily().hashCode());
        hashCode = 31 * hashCode + (this.getStorageProfileId() == null ? 0 : this.getStorageProfileId().hashCode());
        return hashCode;
    }

    public GetStorageProfileForQueueResult clone() {
        try {
            return (GetStorageProfileForQueueResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

