/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.deadline.model.StepDependency;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListStepDependenciesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<StepDependency> dependencies;
    private String nextToken;

    public List<StepDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Collection<StepDependency> dependencies) {
        if (dependencies == null) {
            this.dependencies = null;
            return;
        }
        this.dependencies = new ArrayList<StepDependency>(dependencies);
    }

    public ListStepDependenciesResult withDependencies(StepDependency ... dependencies) {
        if (this.dependencies == null) {
            this.setDependencies(new ArrayList<StepDependency>(dependencies.length));
        }
        for (StepDependency ele : dependencies) {
            this.dependencies.add(ele);
        }
        return this;
    }

    public ListStepDependenciesResult withDependencies(Collection<StepDependency> dependencies) {
        this.setDependencies(dependencies);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListStepDependenciesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDependencies() != null) {
            sb.append("Dependencies: ").append(this.getDependencies()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepDependenciesResult)) {
            return false;
        }
        ListStepDependenciesResult other = (ListStepDependenciesResult)obj;
        if (other.getDependencies() == null ^ this.getDependencies() == null) {
            return false;
        }
        if (other.getDependencies() != null && !other.getDependencies().equals(this.getDependencies())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDependencies() == null ? 0 : this.getDependencies().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListStepDependenciesResult clone() {
        try {
            return (ListStepDependenciesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

