/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.TaskParameterValue;
import com.amazonaws.services.deadline.model.TaskRunStatus;
import com.amazonaws.services.deadline.model.TaskTargetRunStatus;
import com.amazonaws.services.deadline.model.transform.TaskSearchSummaryMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TaskSearchSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private Date endedAt;
    private Integer failureRetryCount;
    private String jobId;
    private Map<String, TaskParameterValue> parameters;
    private String queueId;
    private String runStatus;
    private Date startedAt;
    private String stepId;
    private String targetRunStatus;
    private String taskId;

    public void setEndedAt(Date endedAt) {
        this.endedAt = endedAt;
    }

    public Date getEndedAt() {
        return this.endedAt;
    }

    public TaskSearchSummary withEndedAt(Date endedAt) {
        this.setEndedAt(endedAt);
        return this;
    }

    public void setFailureRetryCount(Integer failureRetryCount) {
        this.failureRetryCount = failureRetryCount;
    }

    public Integer getFailureRetryCount() {
        return this.failureRetryCount;
    }

    public TaskSearchSummary withFailureRetryCount(Integer failureRetryCount) {
        this.setFailureRetryCount(failureRetryCount);
        return this;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public TaskSearchSummary withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public Map<String, TaskParameterValue> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, TaskParameterValue> parameters) {
        this.parameters = parameters;
    }

    public TaskSearchSummary withParameters(Map<String, TaskParameterValue> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public TaskSearchSummary addParametersEntry(String key, TaskParameterValue value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, TaskParameterValue>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public TaskSearchSummary clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public TaskSearchSummary withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public void setRunStatus(String runStatus) {
        this.runStatus = runStatus;
    }

    public String getRunStatus() {
        return this.runStatus;
    }

    public TaskSearchSummary withRunStatus(String runStatus) {
        this.setRunStatus(runStatus);
        return this;
    }

    public TaskSearchSummary withRunStatus(TaskRunStatus runStatus) {
        this.runStatus = runStatus.toString();
        return this;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public TaskSearchSummary withStartedAt(Date startedAt) {
        this.setStartedAt(startedAt);
        return this;
    }

    public void setStepId(String stepId) {
        this.stepId = stepId;
    }

    public String getStepId() {
        return this.stepId;
    }

    public TaskSearchSummary withStepId(String stepId) {
        this.setStepId(stepId);
        return this;
    }

    public void setTargetRunStatus(String targetRunStatus) {
        this.targetRunStatus = targetRunStatus;
    }

    public String getTargetRunStatus() {
        return this.targetRunStatus;
    }

    public TaskSearchSummary withTargetRunStatus(String targetRunStatus) {
        this.setTargetRunStatus(targetRunStatus);
        return this;
    }

    public TaskSearchSummary withTargetRunStatus(TaskTargetRunStatus targetRunStatus) {
        this.targetRunStatus = targetRunStatus.toString();
        return this;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public TaskSearchSummary withTaskId(String taskId) {
        this.setTaskId(taskId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndedAt() != null) {
            sb.append("EndedAt: ").append(this.getEndedAt()).append(",");
        }
        if (this.getFailureRetryCount() != null) {
            sb.append("FailureRetryCount: ").append(this.getFailureRetryCount()).append(",");
        }
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getQueueId() != null) {
            sb.append("QueueId: ").append(this.getQueueId()).append(",");
        }
        if (this.getRunStatus() != null) {
            sb.append("RunStatus: ").append(this.getRunStatus()).append(",");
        }
        if (this.getStartedAt() != null) {
            sb.append("StartedAt: ").append(this.getStartedAt()).append(",");
        }
        if (this.getStepId() != null) {
            sb.append("StepId: ").append(this.getStepId()).append(",");
        }
        if (this.getTargetRunStatus() != null) {
            sb.append("TargetRunStatus: ").append(this.getTargetRunStatus()).append(",");
        }
        if (this.getTaskId() != null) {
            sb.append("TaskId: ").append(this.getTaskId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSearchSummary)) {
            return false;
        }
        TaskSearchSummary other = (TaskSearchSummary)obj;
        if (other.getEndedAt() == null ^ this.getEndedAt() == null) {
            return false;
        }
        if (other.getEndedAt() != null && !other.getEndedAt().equals(this.getEndedAt())) {
            return false;
        }
        if (other.getFailureRetryCount() == null ^ this.getFailureRetryCount() == null) {
            return false;
        }
        if (other.getFailureRetryCount() != null && !other.getFailureRetryCount().equals(this.getFailureRetryCount())) {
            return false;
        }
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getQueueId() == null ^ this.getQueueId() == null) {
            return false;
        }
        if (other.getQueueId() != null && !other.getQueueId().equals(this.getQueueId())) {
            return false;
        }
        if (other.getRunStatus() == null ^ this.getRunStatus() == null) {
            return false;
        }
        if (other.getRunStatus() != null && !other.getRunStatus().equals(this.getRunStatus())) {
            return false;
        }
        if (other.getStartedAt() == null ^ this.getStartedAt() == null) {
            return false;
        }
        if (other.getStartedAt() != null && !other.getStartedAt().equals(this.getStartedAt())) {
            return false;
        }
        if (other.getStepId() == null ^ this.getStepId() == null) {
            return false;
        }
        if (other.getStepId() != null && !other.getStepId().equals(this.getStepId())) {
            return false;
        }
        if (other.getTargetRunStatus() == null ^ this.getTargetRunStatus() == null) {
            return false;
        }
        if (other.getTargetRunStatus() != null && !other.getTargetRunStatus().equals(this.getTargetRunStatus())) {
            return false;
        }
        if (other.getTaskId() == null ^ this.getTaskId() == null) {
            return false;
        }
        return other.getTaskId() == null || other.getTaskId().equals(this.getTaskId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndedAt() == null ? 0 : this.getEndedAt().hashCode());
        hashCode = 31 * hashCode + (this.getFailureRetryCount() == null ? 0 : this.getFailureRetryCount().hashCode());
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getQueueId() == null ? 0 : this.getQueueId().hashCode());
        hashCode = 31 * hashCode + (this.getRunStatus() == null ? 0 : this.getRunStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStartedAt() == null ? 0 : this.getStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStepId() == null ? 0 : this.getStepId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetRunStatus() == null ? 0 : this.getTargetRunStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTaskId() == null ? 0 : this.getTaskId().hashCode());
        return hashCode;
    }

    public TaskSearchSummary clone() {
        try {
            return (TaskSearchSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskSearchSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

