/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.deadline.model.FileSystemLocation;
import com.amazonaws.services.deadline.model.StorageProfileOperatingSystemFamily;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateStorageProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String displayName;
    private String farmId;
    private List<FileSystemLocation> fileSystemLocationsToAdd;
    private List<FileSystemLocation> fileSystemLocationsToRemove;
    private String osFamily;
    private String storageProfileId;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public UpdateStorageProfileRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public UpdateStorageProfileRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setFarmId(String farmId) {
        this.farmId = farmId;
    }

    public String getFarmId() {
        return this.farmId;
    }

    public UpdateStorageProfileRequest withFarmId(String farmId) {
        this.setFarmId(farmId);
        return this;
    }

    public List<FileSystemLocation> getFileSystemLocationsToAdd() {
        return this.fileSystemLocationsToAdd;
    }

    public void setFileSystemLocationsToAdd(Collection<FileSystemLocation> fileSystemLocationsToAdd) {
        if (fileSystemLocationsToAdd == null) {
            this.fileSystemLocationsToAdd = null;
            return;
        }
        this.fileSystemLocationsToAdd = new ArrayList<FileSystemLocation>(fileSystemLocationsToAdd);
    }

    public UpdateStorageProfileRequest withFileSystemLocationsToAdd(FileSystemLocation ... fileSystemLocationsToAdd) {
        if (this.fileSystemLocationsToAdd == null) {
            this.setFileSystemLocationsToAdd(new ArrayList<FileSystemLocation>(fileSystemLocationsToAdd.length));
        }
        for (FileSystemLocation ele : fileSystemLocationsToAdd) {
            this.fileSystemLocationsToAdd.add(ele);
        }
        return this;
    }

    public UpdateStorageProfileRequest withFileSystemLocationsToAdd(Collection<FileSystemLocation> fileSystemLocationsToAdd) {
        this.setFileSystemLocationsToAdd(fileSystemLocationsToAdd);
        return this;
    }

    public List<FileSystemLocation> getFileSystemLocationsToRemove() {
        return this.fileSystemLocationsToRemove;
    }

    public void setFileSystemLocationsToRemove(Collection<FileSystemLocation> fileSystemLocationsToRemove) {
        if (fileSystemLocationsToRemove == null) {
            this.fileSystemLocationsToRemove = null;
            return;
        }
        this.fileSystemLocationsToRemove = new ArrayList<FileSystemLocation>(fileSystemLocationsToRemove);
    }

    public UpdateStorageProfileRequest withFileSystemLocationsToRemove(FileSystemLocation ... fileSystemLocationsToRemove) {
        if (this.fileSystemLocationsToRemove == null) {
            this.setFileSystemLocationsToRemove(new ArrayList<FileSystemLocation>(fileSystemLocationsToRemove.length));
        }
        for (FileSystemLocation ele : fileSystemLocationsToRemove) {
            this.fileSystemLocationsToRemove.add(ele);
        }
        return this;
    }

    public UpdateStorageProfileRequest withFileSystemLocationsToRemove(Collection<FileSystemLocation> fileSystemLocationsToRemove) {
        this.setFileSystemLocationsToRemove(fileSystemLocationsToRemove);
        return this;
    }

    public void setOsFamily(String osFamily) {
        this.osFamily = osFamily;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public UpdateStorageProfileRequest withOsFamily(String osFamily) {
        this.setOsFamily(osFamily);
        return this;
    }

    public UpdateStorageProfileRequest withOsFamily(StorageProfileOperatingSystemFamily osFamily) {
        this.osFamily = osFamily.toString();
        return this;
    }

    public void setStorageProfileId(String storageProfileId) {
        this.storageProfileId = storageProfileId;
    }

    public String getStorageProfileId() {
        return this.storageProfileId;
    }

    public UpdateStorageProfileRequest withStorageProfileId(String storageProfileId) {
        this.setStorageProfileId(storageProfileId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getFarmId() != null) {
            sb.append("FarmId: ").append(this.getFarmId()).append(",");
        }
        if (this.getFileSystemLocationsToAdd() != null) {
            sb.append("FileSystemLocationsToAdd: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getFileSystemLocationsToRemove() != null) {
            sb.append("FileSystemLocationsToRemove: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOsFamily() != null) {
            sb.append("OsFamily: ").append(this.getOsFamily()).append(",");
        }
        if (this.getStorageProfileId() != null) {
            sb.append("StorageProfileId: ").append(this.getStorageProfileId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStorageProfileRequest)) {
            return false;
        }
        UpdateStorageProfileRequest other = (UpdateStorageProfileRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getFarmId() == null ^ this.getFarmId() == null) {
            return false;
        }
        if (other.getFarmId() != null && !other.getFarmId().equals(this.getFarmId())) {
            return false;
        }
        if (other.getFileSystemLocationsToAdd() == null ^ this.getFileSystemLocationsToAdd() == null) {
            return false;
        }
        if (other.getFileSystemLocationsToAdd() != null && !other.getFileSystemLocationsToAdd().equals(this.getFileSystemLocationsToAdd())) {
            return false;
        }
        if (other.getFileSystemLocationsToRemove() == null ^ this.getFileSystemLocationsToRemove() == null) {
            return false;
        }
        if (other.getFileSystemLocationsToRemove() != null && !other.getFileSystemLocationsToRemove().equals(this.getFileSystemLocationsToRemove())) {
            return false;
        }
        if (other.getOsFamily() == null ^ this.getOsFamily() == null) {
            return false;
        }
        if (other.getOsFamily() != null && !other.getOsFamily().equals(this.getOsFamily())) {
            return false;
        }
        if (other.getStorageProfileId() == null ^ this.getStorageProfileId() == null) {
            return false;
        }
        return other.getStorageProfileId() == null || other.getStorageProfileId().equals(this.getStorageProfileId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getFarmId() == null ? 0 : this.getFarmId().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemLocationsToAdd() == null ? 0 : this.getFileSystemLocationsToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemLocationsToRemove() == null ? 0 : this.getFileSystemLocationsToRemove().hashCode());
        hashCode = 31 * hashCode + (this.getOsFamily() == null ? 0 : this.getOsFamily().hashCode());
        hashCode = 31 * hashCode + (this.getStorageProfileId() == null ? 0 : this.getStorageProfileId().hashCode());
        return hashCode;
    }

    public UpdateStorageProfileRequest clone() {
        return (UpdateStorageProfileRequest)super.clone();
    }
}

