/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Test;
import com.amazonaws.services.devicefarm.model.transform.CountersJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.DeviceMinutesJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class TestJsonMarshaller {
    private static TestJsonMarshaller instance;

    public void marshall(Test test, JSONWriter jsonWriter) {
        if (test == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (test.getArn() != null) {
                jsonWriter.key("arn").value((Object)test.getArn());
            }
            if (test.getName() != null) {
                jsonWriter.key("name").value((Object)test.getName());
            }
            if (test.getType() != null) {
                jsonWriter.key("type").value((Object)test.getType());
            }
            if (test.getCreated() != null) {
                jsonWriter.key("created").value(test.getCreated());
            }
            if (test.getStatus() != null) {
                jsonWriter.key("status").value((Object)test.getStatus());
            }
            if (test.getResult() != null) {
                jsonWriter.key("result").value((Object)test.getResult());
            }
            if (test.getStarted() != null) {
                jsonWriter.key("started").value(test.getStarted());
            }
            if (test.getStopped() != null) {
                jsonWriter.key("stopped").value(test.getStopped());
            }
            if (test.getCounters() != null) {
                jsonWriter.key("counters");
                CountersJsonMarshaller.getInstance().marshall(test.getCounters(), jsonWriter);
            }
            if (test.getMessage() != null) {
                jsonWriter.key("message").value((Object)test.getMessage());
            }
            if (test.getDeviceMinutes() != null) {
                jsonWriter.key("deviceMinutes");
                DeviceMinutesJsonMarshaller.getInstance().marshall(test.getDeviceMinutes(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TestJsonMarshaller();
        }
        return instance;
    }
}

