/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.devopsguru.AmazonDevOpsGuruAsync;
import com.amazonaws.services.devopsguru.AmazonDevOpsGuruAsyncClientBuilder;
import com.amazonaws.services.devopsguru.AmazonDevOpsGuruClient;
import com.amazonaws.services.devopsguru.model.AddNotificationChannelRequest;
import com.amazonaws.services.devopsguru.model.AddNotificationChannelResult;
import com.amazonaws.services.devopsguru.model.DescribeAccountHealthRequest;
import com.amazonaws.services.devopsguru.model.DescribeAccountHealthResult;
import com.amazonaws.services.devopsguru.model.DescribeAccountOverviewRequest;
import com.amazonaws.services.devopsguru.model.DescribeAccountOverviewResult;
import com.amazonaws.services.devopsguru.model.DescribeAnomalyRequest;
import com.amazonaws.services.devopsguru.model.DescribeAnomalyResult;
import com.amazonaws.services.devopsguru.model.DescribeFeedbackRequest;
import com.amazonaws.services.devopsguru.model.DescribeFeedbackResult;
import com.amazonaws.services.devopsguru.model.DescribeInsightRequest;
import com.amazonaws.services.devopsguru.model.DescribeInsightResult;
import com.amazonaws.services.devopsguru.model.DescribeResourceCollectionHealthRequest;
import com.amazonaws.services.devopsguru.model.DescribeResourceCollectionHealthResult;
import com.amazonaws.services.devopsguru.model.DescribeServiceIntegrationRequest;
import com.amazonaws.services.devopsguru.model.DescribeServiceIntegrationResult;
import com.amazonaws.services.devopsguru.model.GetCostEstimationRequest;
import com.amazonaws.services.devopsguru.model.GetCostEstimationResult;
import com.amazonaws.services.devopsguru.model.GetResourceCollectionRequest;
import com.amazonaws.services.devopsguru.model.GetResourceCollectionResult;
import com.amazonaws.services.devopsguru.model.ListAnomaliesForInsightRequest;
import com.amazonaws.services.devopsguru.model.ListAnomaliesForInsightResult;
import com.amazonaws.services.devopsguru.model.ListEventsRequest;
import com.amazonaws.services.devopsguru.model.ListEventsResult;
import com.amazonaws.services.devopsguru.model.ListInsightsRequest;
import com.amazonaws.services.devopsguru.model.ListInsightsResult;
import com.amazonaws.services.devopsguru.model.ListNotificationChannelsRequest;
import com.amazonaws.services.devopsguru.model.ListNotificationChannelsResult;
import com.amazonaws.services.devopsguru.model.ListRecommendationsRequest;
import com.amazonaws.services.devopsguru.model.ListRecommendationsResult;
import com.amazonaws.services.devopsguru.model.PutFeedbackRequest;
import com.amazonaws.services.devopsguru.model.PutFeedbackResult;
import com.amazonaws.services.devopsguru.model.RemoveNotificationChannelRequest;
import com.amazonaws.services.devopsguru.model.RemoveNotificationChannelResult;
import com.amazonaws.services.devopsguru.model.SearchInsightsRequest;
import com.amazonaws.services.devopsguru.model.SearchInsightsResult;
import com.amazonaws.services.devopsguru.model.StartCostEstimationRequest;
import com.amazonaws.services.devopsguru.model.StartCostEstimationResult;
import com.amazonaws.services.devopsguru.model.UpdateResourceCollectionRequest;
import com.amazonaws.services.devopsguru.model.UpdateResourceCollectionResult;
import com.amazonaws.services.devopsguru.model.UpdateServiceIntegrationRequest;
import com.amazonaws.services.devopsguru.model.UpdateServiceIntegrationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonDevOpsGuruAsyncClient
extends AmazonDevOpsGuruClient
implements AmazonDevOpsGuruAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonDevOpsGuruAsyncClientBuilder asyncBuilder() {
        return AmazonDevOpsGuruAsyncClientBuilder.standard();
    }

    AmazonDevOpsGuruAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonDevOpsGuruAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddNotificationChannelResult> addNotificationChannelAsync(AddNotificationChannelRequest request) {
        return this.addNotificationChannelAsync(request, null);
    }

    @Override
    public Future<AddNotificationChannelResult> addNotificationChannelAsync(AddNotificationChannelRequest request, final AsyncHandler<AddNotificationChannelRequest, AddNotificationChannelResult> asyncHandler) {
        final AddNotificationChannelRequest finalRequest = (AddNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddNotificationChannelResult>(){

            @Override
            public AddNotificationChannelResult call() throws Exception {
                AddNotificationChannelResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeAddNotificationChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountHealthResult> describeAccountHealthAsync(DescribeAccountHealthRequest request) {
        return this.describeAccountHealthAsync(request, null);
    }

    @Override
    public Future<DescribeAccountHealthResult> describeAccountHealthAsync(DescribeAccountHealthRequest request, final AsyncHandler<DescribeAccountHealthRequest, DescribeAccountHealthResult> asyncHandler) {
        final DescribeAccountHealthRequest finalRequest = (DescribeAccountHealthRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAccountHealthResult>(){

            @Override
            public DescribeAccountHealthResult call() throws Exception {
                DescribeAccountHealthResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeDescribeAccountHealth(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountOverviewResult> describeAccountOverviewAsync(DescribeAccountOverviewRequest request) {
        return this.describeAccountOverviewAsync(request, null);
    }

    @Override
    public Future<DescribeAccountOverviewResult> describeAccountOverviewAsync(DescribeAccountOverviewRequest request, final AsyncHandler<DescribeAccountOverviewRequest, DescribeAccountOverviewResult> asyncHandler) {
        final DescribeAccountOverviewRequest finalRequest = (DescribeAccountOverviewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAccountOverviewResult>(){

            @Override
            public DescribeAccountOverviewResult call() throws Exception {
                DescribeAccountOverviewResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeDescribeAccountOverview(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAnomalyResult> describeAnomalyAsync(DescribeAnomalyRequest request) {
        return this.describeAnomalyAsync(request, null);
    }

    @Override
    public Future<DescribeAnomalyResult> describeAnomalyAsync(DescribeAnomalyRequest request, final AsyncHandler<DescribeAnomalyRequest, DescribeAnomalyResult> asyncHandler) {
        final DescribeAnomalyRequest finalRequest = (DescribeAnomalyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAnomalyResult>(){

            @Override
            public DescribeAnomalyResult call() throws Exception {
                DescribeAnomalyResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeDescribeAnomaly(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFeedbackResult> describeFeedbackAsync(DescribeFeedbackRequest request) {
        return this.describeFeedbackAsync(request, null);
    }

    @Override
    public Future<DescribeFeedbackResult> describeFeedbackAsync(DescribeFeedbackRequest request, final AsyncHandler<DescribeFeedbackRequest, DescribeFeedbackResult> asyncHandler) {
        final DescribeFeedbackRequest finalRequest = (DescribeFeedbackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFeedbackResult>(){

            @Override
            public DescribeFeedbackResult call() throws Exception {
                DescribeFeedbackResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeDescribeFeedback(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInsightResult> describeInsightAsync(DescribeInsightRequest request) {
        return this.describeInsightAsync(request, null);
    }

    @Override
    public Future<DescribeInsightResult> describeInsightAsync(DescribeInsightRequest request, final AsyncHandler<DescribeInsightRequest, DescribeInsightResult> asyncHandler) {
        final DescribeInsightRequest finalRequest = (DescribeInsightRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInsightResult>(){

            @Override
            public DescribeInsightResult call() throws Exception {
                DescribeInsightResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeDescribeInsight(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeResourceCollectionHealthResult> describeResourceCollectionHealthAsync(DescribeResourceCollectionHealthRequest request) {
        return this.describeResourceCollectionHealthAsync(request, null);
    }

    @Override
    public Future<DescribeResourceCollectionHealthResult> describeResourceCollectionHealthAsync(DescribeResourceCollectionHealthRequest request, final AsyncHandler<DescribeResourceCollectionHealthRequest, DescribeResourceCollectionHealthResult> asyncHandler) {
        final DescribeResourceCollectionHealthRequest finalRequest = (DescribeResourceCollectionHealthRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeResourceCollectionHealthResult>(){

            @Override
            public DescribeResourceCollectionHealthResult call() throws Exception {
                DescribeResourceCollectionHealthResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeDescribeResourceCollectionHealth(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServiceIntegrationResult> describeServiceIntegrationAsync(DescribeServiceIntegrationRequest request) {
        return this.describeServiceIntegrationAsync(request, null);
    }

    @Override
    public Future<DescribeServiceIntegrationResult> describeServiceIntegrationAsync(DescribeServiceIntegrationRequest request, final AsyncHandler<DescribeServiceIntegrationRequest, DescribeServiceIntegrationResult> asyncHandler) {
        final DescribeServiceIntegrationRequest finalRequest = (DescribeServiceIntegrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeServiceIntegrationResult>(){

            @Override
            public DescribeServiceIntegrationResult call() throws Exception {
                DescribeServiceIntegrationResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeDescribeServiceIntegration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCostEstimationResult> getCostEstimationAsync(GetCostEstimationRequest request) {
        return this.getCostEstimationAsync(request, null);
    }

    @Override
    public Future<GetCostEstimationResult> getCostEstimationAsync(GetCostEstimationRequest request, final AsyncHandler<GetCostEstimationRequest, GetCostEstimationResult> asyncHandler) {
        final GetCostEstimationRequest finalRequest = (GetCostEstimationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCostEstimationResult>(){

            @Override
            public GetCostEstimationResult call() throws Exception {
                GetCostEstimationResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeGetCostEstimation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceCollectionResult> getResourceCollectionAsync(GetResourceCollectionRequest request) {
        return this.getResourceCollectionAsync(request, null);
    }

    @Override
    public Future<GetResourceCollectionResult> getResourceCollectionAsync(GetResourceCollectionRequest request, final AsyncHandler<GetResourceCollectionRequest, GetResourceCollectionResult> asyncHandler) {
        final GetResourceCollectionRequest finalRequest = (GetResourceCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceCollectionResult>(){

            @Override
            public GetResourceCollectionResult call() throws Exception {
                GetResourceCollectionResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeGetResourceCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAnomaliesForInsightResult> listAnomaliesForInsightAsync(ListAnomaliesForInsightRequest request) {
        return this.listAnomaliesForInsightAsync(request, null);
    }

    @Override
    public Future<ListAnomaliesForInsightResult> listAnomaliesForInsightAsync(ListAnomaliesForInsightRequest request, final AsyncHandler<ListAnomaliesForInsightRequest, ListAnomaliesForInsightResult> asyncHandler) {
        final ListAnomaliesForInsightRequest finalRequest = (ListAnomaliesForInsightRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAnomaliesForInsightResult>(){

            @Override
            public ListAnomaliesForInsightResult call() throws Exception {
                ListAnomaliesForInsightResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeListAnomaliesForInsight(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventsResult> listEventsAsync(ListEventsRequest request) {
        return this.listEventsAsync(request, null);
    }

    @Override
    public Future<ListEventsResult> listEventsAsync(ListEventsRequest request, final AsyncHandler<ListEventsRequest, ListEventsResult> asyncHandler) {
        final ListEventsRequest finalRequest = (ListEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEventsResult>(){

            @Override
            public ListEventsResult call() throws Exception {
                ListEventsResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeListEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInsightsResult> listInsightsAsync(ListInsightsRequest request) {
        return this.listInsightsAsync(request, null);
    }

    @Override
    public Future<ListInsightsResult> listInsightsAsync(ListInsightsRequest request, final AsyncHandler<ListInsightsRequest, ListInsightsResult> asyncHandler) {
        final ListInsightsRequest finalRequest = (ListInsightsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInsightsResult>(){

            @Override
            public ListInsightsResult call() throws Exception {
                ListInsightsResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeListInsights(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNotificationChannelsResult> listNotificationChannelsAsync(ListNotificationChannelsRequest request) {
        return this.listNotificationChannelsAsync(request, null);
    }

    @Override
    public Future<ListNotificationChannelsResult> listNotificationChannelsAsync(ListNotificationChannelsRequest request, final AsyncHandler<ListNotificationChannelsRequest, ListNotificationChannelsResult> asyncHandler) {
        final ListNotificationChannelsRequest finalRequest = (ListNotificationChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNotificationChannelsResult>(){

            @Override
            public ListNotificationChannelsResult call() throws Exception {
                ListNotificationChannelsResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeListNotificationChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecommendationsResult> listRecommendationsAsync(ListRecommendationsRequest request) {
        return this.listRecommendationsAsync(request, null);
    }

    @Override
    public Future<ListRecommendationsResult> listRecommendationsAsync(ListRecommendationsRequest request, final AsyncHandler<ListRecommendationsRequest, ListRecommendationsResult> asyncHandler) {
        final ListRecommendationsRequest finalRequest = (ListRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRecommendationsResult>(){

            @Override
            public ListRecommendationsResult call() throws Exception {
                ListRecommendationsResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeListRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutFeedbackResult> putFeedbackAsync(PutFeedbackRequest request) {
        return this.putFeedbackAsync(request, null);
    }

    @Override
    public Future<PutFeedbackResult> putFeedbackAsync(PutFeedbackRequest request, final AsyncHandler<PutFeedbackRequest, PutFeedbackResult> asyncHandler) {
        final PutFeedbackRequest finalRequest = (PutFeedbackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutFeedbackResult>(){

            @Override
            public PutFeedbackResult call() throws Exception {
                PutFeedbackResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executePutFeedback(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveNotificationChannelResult> removeNotificationChannelAsync(RemoveNotificationChannelRequest request) {
        return this.removeNotificationChannelAsync(request, null);
    }

    @Override
    public Future<RemoveNotificationChannelResult> removeNotificationChannelAsync(RemoveNotificationChannelRequest request, final AsyncHandler<RemoveNotificationChannelRequest, RemoveNotificationChannelResult> asyncHandler) {
        final RemoveNotificationChannelRequest finalRequest = (RemoveNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveNotificationChannelResult>(){

            @Override
            public RemoveNotificationChannelResult call() throws Exception {
                RemoveNotificationChannelResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeRemoveNotificationChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchInsightsResult> searchInsightsAsync(SearchInsightsRequest request) {
        return this.searchInsightsAsync(request, null);
    }

    @Override
    public Future<SearchInsightsResult> searchInsightsAsync(SearchInsightsRequest request, final AsyncHandler<SearchInsightsRequest, SearchInsightsResult> asyncHandler) {
        final SearchInsightsRequest finalRequest = (SearchInsightsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchInsightsResult>(){

            @Override
            public SearchInsightsResult call() throws Exception {
                SearchInsightsResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeSearchInsights(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartCostEstimationResult> startCostEstimationAsync(StartCostEstimationRequest request) {
        return this.startCostEstimationAsync(request, null);
    }

    @Override
    public Future<StartCostEstimationResult> startCostEstimationAsync(StartCostEstimationRequest request, final AsyncHandler<StartCostEstimationRequest, StartCostEstimationResult> asyncHandler) {
        final StartCostEstimationRequest finalRequest = (StartCostEstimationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartCostEstimationResult>(){

            @Override
            public StartCostEstimationResult call() throws Exception {
                StartCostEstimationResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeStartCostEstimation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateResourceCollectionResult> updateResourceCollectionAsync(UpdateResourceCollectionRequest request) {
        return this.updateResourceCollectionAsync(request, null);
    }

    @Override
    public Future<UpdateResourceCollectionResult> updateResourceCollectionAsync(UpdateResourceCollectionRequest request, final AsyncHandler<UpdateResourceCollectionRequest, UpdateResourceCollectionResult> asyncHandler) {
        final UpdateResourceCollectionRequest finalRequest = (UpdateResourceCollectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateResourceCollectionResult>(){

            @Override
            public UpdateResourceCollectionResult call() throws Exception {
                UpdateResourceCollectionResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeUpdateResourceCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServiceIntegrationResult> updateServiceIntegrationAsync(UpdateServiceIntegrationRequest request) {
        return this.updateServiceIntegrationAsync(request, null);
    }

    @Override
    public Future<UpdateServiceIntegrationResult> updateServiceIntegrationAsync(UpdateServiceIntegrationRequest request, final AsyncHandler<UpdateServiceIntegrationRequest, UpdateServiceIntegrationResult> asyncHandler) {
        final UpdateServiceIntegrationRequest finalRequest = (UpdateServiceIntegrationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateServiceIntegrationResult>(){

            @Override
            public UpdateServiceIntegrationResult call() throws Exception {
                UpdateServiceIntegrationResult result = null;
                try {
                    result = AmazonDevOpsGuruAsyncClient.this.executeUpdateServiceIntegration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

