/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DirectoryConnectSettings;
import com.amazonaws.util.json.JSONWriter;

public class DirectoryConnectSettingsJsonMarshaller {
    private static DirectoryConnectSettingsJsonMarshaller instance;

    public void marshall(DirectoryConnectSettings directoryConnectSettings, JSONWriter jsonWriter) {
        if (directoryConnectSettings == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList customerDnsIpsList;
            SdkInternalList subnetIdsList;
            jsonWriter.object();
            if (directoryConnectSettings.getVpcId() != null) {
                jsonWriter.key("VpcId").value((Object)directoryConnectSettings.getVpcId());
            }
            if (!(subnetIdsList = (SdkInternalList)directoryConnectSettings.getSubnetIds()).isEmpty() || !subnetIdsList.isAutoConstruct()) {
                jsonWriter.key("SubnetIds");
                jsonWriter.array();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonWriter.value((Object)subnetIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(customerDnsIpsList = (SdkInternalList)directoryConnectSettings.getCustomerDnsIps()).isEmpty() || !customerDnsIpsList.isAutoConstruct()) {
                jsonWriter.key("CustomerDnsIps");
                jsonWriter.array();
                for (String customerDnsIpsListValue : customerDnsIpsList) {
                    if (customerDnsIpsListValue == null) continue;
                    jsonWriter.value((Object)customerDnsIpsListValue);
                }
                jsonWriter.endArray();
            }
            if (directoryConnectSettings.getCustomerUserName() != null) {
                jsonWriter.key("CustomerUserName").value((Object)directoryConnectSettings.getCustomerUserName());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DirectoryConnectSettingsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DirectoryConnectSettingsJsonMarshaller();
        }
        return instance;
    }
}

