/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DirectoryDescription;
import com.amazonaws.services.directory.model.transform.DirectoryConnectSettingsDescriptionJsonMarshaller;
import com.amazonaws.services.directory.model.transform.DirectoryVpcSettingsDescriptionJsonMarshaller;
import com.amazonaws.services.directory.model.transform.RadiusSettingsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DirectoryDescriptionJsonMarshaller {
    private static DirectoryDescriptionJsonMarshaller instance;

    public void marshall(DirectoryDescription directoryDescription, JSONWriter jsonWriter) {
        if (directoryDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList dnsIpAddrsList;
            jsonWriter.object();
            if (directoryDescription.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value((Object)directoryDescription.getDirectoryId());
            }
            if (directoryDescription.getName() != null) {
                jsonWriter.key("Name").value((Object)directoryDescription.getName());
            }
            if (directoryDescription.getShortName() != null) {
                jsonWriter.key("ShortName").value((Object)directoryDescription.getShortName());
            }
            if (directoryDescription.getSize() != null) {
                jsonWriter.key("Size").value((Object)directoryDescription.getSize());
            }
            if (directoryDescription.getAlias() != null) {
                jsonWriter.key("Alias").value((Object)directoryDescription.getAlias());
            }
            if (directoryDescription.getAccessUrl() != null) {
                jsonWriter.key("AccessUrl").value((Object)directoryDescription.getAccessUrl());
            }
            if (directoryDescription.getDescription() != null) {
                jsonWriter.key("Description").value((Object)directoryDescription.getDescription());
            }
            if (!(dnsIpAddrsList = (SdkInternalList)directoryDescription.getDnsIpAddrs()).isEmpty() || !dnsIpAddrsList.isAutoConstruct()) {
                jsonWriter.key("DnsIpAddrs");
                jsonWriter.array();
                for (String dnsIpAddrsListValue : dnsIpAddrsList) {
                    if (dnsIpAddrsListValue == null) continue;
                    jsonWriter.value((Object)dnsIpAddrsListValue);
                }
                jsonWriter.endArray();
            }
            if (directoryDescription.getStage() != null) {
                jsonWriter.key("Stage").value((Object)directoryDescription.getStage());
            }
            if (directoryDescription.getLaunchTime() != null) {
                jsonWriter.key("LaunchTime").value(directoryDescription.getLaunchTime());
            }
            if (directoryDescription.getStageLastUpdatedDateTime() != null) {
                jsonWriter.key("StageLastUpdatedDateTime").value(directoryDescription.getStageLastUpdatedDateTime());
            }
            if (directoryDescription.getType() != null) {
                jsonWriter.key("Type").value((Object)directoryDescription.getType());
            }
            if (directoryDescription.getVpcSettings() != null) {
                jsonWriter.key("VpcSettings");
                DirectoryVpcSettingsDescriptionJsonMarshaller.getInstance().marshall(directoryDescription.getVpcSettings(), jsonWriter);
            }
            if (directoryDescription.getConnectSettings() != null) {
                jsonWriter.key("ConnectSettings");
                DirectoryConnectSettingsDescriptionJsonMarshaller.getInstance().marshall(directoryDescription.getConnectSettings(), jsonWriter);
            }
            if (directoryDescription.getRadiusSettings() != null) {
                jsonWriter.key("RadiusSettings");
                RadiusSettingsJsonMarshaller.getInstance().marshall(directoryDescription.getRadiusSettings(), jsonWriter);
            }
            if (directoryDescription.getRadiusStatus() != null) {
                jsonWriter.key("RadiusStatus").value((Object)directoryDescription.getRadiusStatus());
            }
            if (directoryDescription.getStageReason() != null) {
                jsonWriter.key("StageReason").value((Object)directoryDescription.getStageReason());
            }
            if (directoryDescription.getSsoEnabled() != null) {
                jsonWriter.key("SsoEnabled").value((Object)directoryDescription.getSsoEnabled());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DirectoryDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DirectoryDescriptionJsonMarshaller();
        }
        return instance;
    }
}

