/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.directory.model.Snapshot;
import com.amazonaws.util.json.JSONWriter;

public class SnapshotJsonMarshaller {
    private static SnapshotJsonMarshaller instance;

    public void marshall(Snapshot snapshot, JSONWriter jsonWriter) {
        if (snapshot == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (snapshot.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value((Object)snapshot.getDirectoryId());
            }
            if (snapshot.getSnapshotId() != null) {
                jsonWriter.key("SnapshotId").value((Object)snapshot.getSnapshotId());
            }
            if (snapshot.getType() != null) {
                jsonWriter.key("Type").value((Object)snapshot.getType());
            }
            if (snapshot.getName() != null) {
                jsonWriter.key("Name").value((Object)snapshot.getName());
            }
            if (snapshot.getStatus() != null) {
                jsonWriter.key("Status").value((Object)snapshot.getStatus());
            }
            if (snapshot.getStartTime() != null) {
                jsonWriter.key("StartTime").value(snapshot.getStartTime());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SnapshotJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SnapshotJsonMarshaller();
        }
        return instance;
    }
}

