/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.drs.AWSdrs;
import com.amazonaws.services.drs.AWSdrsClientBuilder;
import com.amazonaws.services.drs.model.AWSdrsException;
import com.amazonaws.services.drs.model.CreateExtendedSourceServerRequest;
import com.amazonaws.services.drs.model.CreateExtendedSourceServerResult;
import com.amazonaws.services.drs.model.CreateReplicationConfigurationTemplateRequest;
import com.amazonaws.services.drs.model.CreateReplicationConfigurationTemplateResult;
import com.amazonaws.services.drs.model.DeleteJobRequest;
import com.amazonaws.services.drs.model.DeleteJobResult;
import com.amazonaws.services.drs.model.DeleteRecoveryInstanceRequest;
import com.amazonaws.services.drs.model.DeleteRecoveryInstanceResult;
import com.amazonaws.services.drs.model.DeleteReplicationConfigurationTemplateRequest;
import com.amazonaws.services.drs.model.DeleteReplicationConfigurationTemplateResult;
import com.amazonaws.services.drs.model.DeleteSourceServerRequest;
import com.amazonaws.services.drs.model.DeleteSourceServerResult;
import com.amazonaws.services.drs.model.DescribeJobLogItemsRequest;
import com.amazonaws.services.drs.model.DescribeJobLogItemsResult;
import com.amazonaws.services.drs.model.DescribeJobsRequest;
import com.amazonaws.services.drs.model.DescribeJobsResult;
import com.amazonaws.services.drs.model.DescribeRecoveryInstancesRequest;
import com.amazonaws.services.drs.model.DescribeRecoveryInstancesResult;
import com.amazonaws.services.drs.model.DescribeRecoverySnapshotsRequest;
import com.amazonaws.services.drs.model.DescribeRecoverySnapshotsResult;
import com.amazonaws.services.drs.model.DescribeReplicationConfigurationTemplatesRequest;
import com.amazonaws.services.drs.model.DescribeReplicationConfigurationTemplatesResult;
import com.amazonaws.services.drs.model.DescribeSourceServersRequest;
import com.amazonaws.services.drs.model.DescribeSourceServersResult;
import com.amazonaws.services.drs.model.DisconnectRecoveryInstanceRequest;
import com.amazonaws.services.drs.model.DisconnectRecoveryInstanceResult;
import com.amazonaws.services.drs.model.DisconnectSourceServerRequest;
import com.amazonaws.services.drs.model.DisconnectSourceServerResult;
import com.amazonaws.services.drs.model.GetFailbackReplicationConfigurationRequest;
import com.amazonaws.services.drs.model.GetFailbackReplicationConfigurationResult;
import com.amazonaws.services.drs.model.GetLaunchConfigurationRequest;
import com.amazonaws.services.drs.model.GetLaunchConfigurationResult;
import com.amazonaws.services.drs.model.GetReplicationConfigurationRequest;
import com.amazonaws.services.drs.model.GetReplicationConfigurationResult;
import com.amazonaws.services.drs.model.InitializeServiceRequest;
import com.amazonaws.services.drs.model.InitializeServiceResult;
import com.amazonaws.services.drs.model.ListExtensibleSourceServersRequest;
import com.amazonaws.services.drs.model.ListExtensibleSourceServersResult;
import com.amazonaws.services.drs.model.ListStagingAccountsRequest;
import com.amazonaws.services.drs.model.ListStagingAccountsResult;
import com.amazonaws.services.drs.model.ListTagsForResourceRequest;
import com.amazonaws.services.drs.model.ListTagsForResourceResult;
import com.amazonaws.services.drs.model.RetryDataReplicationRequest;
import com.amazonaws.services.drs.model.RetryDataReplicationResult;
import com.amazonaws.services.drs.model.StartFailbackLaunchRequest;
import com.amazonaws.services.drs.model.StartFailbackLaunchResult;
import com.amazonaws.services.drs.model.StartRecoveryRequest;
import com.amazonaws.services.drs.model.StartRecoveryResult;
import com.amazonaws.services.drs.model.StopFailbackRequest;
import com.amazonaws.services.drs.model.StopFailbackResult;
import com.amazonaws.services.drs.model.TagResourceRequest;
import com.amazonaws.services.drs.model.TagResourceResult;
import com.amazonaws.services.drs.model.TerminateRecoveryInstancesRequest;
import com.amazonaws.services.drs.model.TerminateRecoveryInstancesResult;
import com.amazonaws.services.drs.model.UntagResourceRequest;
import com.amazonaws.services.drs.model.UntagResourceResult;
import com.amazonaws.services.drs.model.UpdateFailbackReplicationConfigurationRequest;
import com.amazonaws.services.drs.model.UpdateFailbackReplicationConfigurationResult;
import com.amazonaws.services.drs.model.UpdateLaunchConfigurationRequest;
import com.amazonaws.services.drs.model.UpdateLaunchConfigurationResult;
import com.amazonaws.services.drs.model.UpdateReplicationConfigurationRequest;
import com.amazonaws.services.drs.model.UpdateReplicationConfigurationResult;
import com.amazonaws.services.drs.model.UpdateReplicationConfigurationTemplateRequest;
import com.amazonaws.services.drs.model.UpdateReplicationConfigurationTemplateResult;
import com.amazonaws.services.drs.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.drs.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.drs.model.transform.CreateExtendedSourceServerRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.CreateExtendedSourceServerResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.CreateReplicationConfigurationTemplateRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.CreateReplicationConfigurationTemplateResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DeleteJobRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DeleteJobResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DeleteRecoveryInstanceRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DeleteRecoveryInstanceResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DeleteReplicationConfigurationTemplateRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DeleteReplicationConfigurationTemplateResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DeleteSourceServerRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DeleteSourceServerResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DescribeJobLogItemsRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DescribeJobLogItemsResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DescribeJobsRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DescribeJobsResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DescribeRecoveryInstancesRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DescribeRecoveryInstancesResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DescribeRecoverySnapshotsRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DescribeRecoverySnapshotsResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DescribeReplicationConfigurationTemplatesRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DescribeReplicationConfigurationTemplatesResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DescribeSourceServersRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DescribeSourceServersResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DisconnectRecoveryInstanceRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DisconnectRecoveryInstanceResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.DisconnectSourceServerRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.DisconnectSourceServerResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.GetFailbackReplicationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.GetFailbackReplicationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.GetLaunchConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.GetLaunchConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.GetReplicationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.GetReplicationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.InitializeServiceRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.InitializeServiceResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.drs.model.transform.ListExtensibleSourceServersRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.ListExtensibleSourceServersResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.ListStagingAccountsRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.ListStagingAccountsResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.drs.model.transform.RetryDataReplicationRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.RetryDataReplicationResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.drs.model.transform.StartFailbackLaunchRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.StartFailbackLaunchResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.StartRecoveryRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.StartRecoveryResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.StopFailbackRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.StopFailbackResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.TerminateRecoveryInstancesRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.TerminateRecoveryInstancesResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.drs.model.transform.UninitializedAccountExceptionUnmarshaller;
import com.amazonaws.services.drs.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.UpdateFailbackReplicationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.UpdateFailbackReplicationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.UpdateLaunchConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.UpdateLaunchConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.UpdateReplicationConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.UpdateReplicationConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.UpdateReplicationConfigurationTemplateRequestProtocolMarshaller;
import com.amazonaws.services.drs.model.transform.UpdateReplicationConfigurationTemplateResultJsonUnmarshaller;
import com.amazonaws.services.drs.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSdrsClient
extends AmazonWebServiceClient
implements AWSdrs {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSdrs.class);
    private static final String DEFAULT_SIGNING_NAME = "drs";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UninitializedAccountException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UninitializedAccountExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSdrsException.class));

    public static AWSdrsClientBuilder builder() {
        return AWSdrsClientBuilder.standard();
    }

    AWSdrsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSdrsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("drs.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/drs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/drs/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateExtendedSourceServerResult createExtendedSourceServer(CreateExtendedSourceServerRequest request) {
        request = (CreateExtendedSourceServerRequest)this.beforeClientExecution(request);
        return this.executeCreateExtendedSourceServer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateExtendedSourceServerResult executeCreateExtendedSourceServer(CreateExtendedSourceServerRequest createExtendedSourceServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createExtendedSourceServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateExtendedSourceServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateExtendedSourceServerRequestProtocolMarshaller(protocolFactory).marshall((CreateExtendedSourceServerRequest)super.beforeMarshalling((AmazonWebServiceRequest)createExtendedSourceServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateExtendedSourceServer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateExtendedSourceServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateExtendedSourceServerResult createExtendedSourceServerResult = (CreateExtendedSourceServerResult)response.getAwsResponse();
            return createExtendedSourceServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateReplicationConfigurationTemplateResult createReplicationConfigurationTemplate(CreateReplicationConfigurationTemplateRequest request) {
        request = (CreateReplicationConfigurationTemplateRequest)this.beforeClientExecution(request);
        return this.executeCreateReplicationConfigurationTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateReplicationConfigurationTemplateResult executeCreateReplicationConfigurationTemplate(CreateReplicationConfigurationTemplateRequest createReplicationConfigurationTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createReplicationConfigurationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateReplicationConfigurationTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateReplicationConfigurationTemplateRequestProtocolMarshaller(protocolFactory).marshall((CreateReplicationConfigurationTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)createReplicationConfigurationTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateReplicationConfigurationTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateReplicationConfigurationTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateReplicationConfigurationTemplateResult createReplicationConfigurationTemplateResult = (CreateReplicationConfigurationTemplateResult)response.getAwsResponse();
            return createReplicationConfigurationTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteJobResult deleteJob(DeleteJobRequest request) {
        request = (DeleteJobRequest)this.beforeClientExecution(request);
        return this.executeDeleteJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteJobResult executeDeleteJob(DeleteJobRequest deleteJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteJobRequestProtocolMarshaller(protocolFactory).marshall((DeleteJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteJobResult deleteJobResult = (DeleteJobResult)response.getAwsResponse();
            return deleteJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRecoveryInstanceResult deleteRecoveryInstance(DeleteRecoveryInstanceRequest request) {
        request = (DeleteRecoveryInstanceRequest)this.beforeClientExecution(request);
        return this.executeDeleteRecoveryInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRecoveryInstanceResult executeDeleteRecoveryInstance(DeleteRecoveryInstanceRequest deleteRecoveryInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRecoveryInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRecoveryInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRecoveryInstanceRequestProtocolMarshaller(protocolFactory).marshall((DeleteRecoveryInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRecoveryInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRecoveryInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRecoveryInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRecoveryInstanceResult deleteRecoveryInstanceResult = (DeleteRecoveryInstanceResult)response.getAwsResponse();
            return deleteRecoveryInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteReplicationConfigurationTemplateResult deleteReplicationConfigurationTemplate(DeleteReplicationConfigurationTemplateRequest request) {
        request = (DeleteReplicationConfigurationTemplateRequest)this.beforeClientExecution(request);
        return this.executeDeleteReplicationConfigurationTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteReplicationConfigurationTemplateResult executeDeleteReplicationConfigurationTemplate(DeleteReplicationConfigurationTemplateRequest deleteReplicationConfigurationTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteReplicationConfigurationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteReplicationConfigurationTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteReplicationConfigurationTemplateRequestProtocolMarshaller(protocolFactory).marshall((DeleteReplicationConfigurationTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteReplicationConfigurationTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteReplicationConfigurationTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteReplicationConfigurationTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteReplicationConfigurationTemplateResult deleteReplicationConfigurationTemplateResult = (DeleteReplicationConfigurationTemplateResult)response.getAwsResponse();
            return deleteReplicationConfigurationTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSourceServerResult deleteSourceServer(DeleteSourceServerRequest request) {
        request = (DeleteSourceServerRequest)this.beforeClientExecution(request);
        return this.executeDeleteSourceServer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSourceServerResult executeDeleteSourceServer(DeleteSourceServerRequest deleteSourceServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSourceServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSourceServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSourceServerRequestProtocolMarshaller(protocolFactory).marshall((DeleteSourceServerRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSourceServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSourceServer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSourceServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSourceServerResult deleteSourceServerResult = (DeleteSourceServerResult)response.getAwsResponse();
            return deleteSourceServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeJobLogItemsResult describeJobLogItems(DescribeJobLogItemsRequest request) {
        request = (DescribeJobLogItemsRequest)this.beforeClientExecution(request);
        return this.executeDescribeJobLogItems(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJobLogItemsResult executeDescribeJobLogItems(DescribeJobLogItemsRequest describeJobLogItemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobLogItemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobLogItemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobLogItemsRequestProtocolMarshaller(protocolFactory).marshall((DescribeJobLogItemsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJobLogItemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeJobLogItems");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobLogItemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJobLogItemsResult describeJobLogItemsResult = (DescribeJobLogItemsResult)response.getAwsResponse();
            return describeJobLogItemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeJobsResult describeJobs(DescribeJobsRequest request) {
        request = (DescribeJobsRequest)this.beforeClientExecution(request);
        return this.executeDescribeJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJobsResult executeDescribeJobs(DescribeJobsRequest describeJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobsRequestProtocolMarshaller(protocolFactory).marshall((DescribeJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJobsResult describeJobsResult = (DescribeJobsResult)response.getAwsResponse();
            return describeJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRecoveryInstancesResult describeRecoveryInstances(DescribeRecoveryInstancesRequest request) {
        request = (DescribeRecoveryInstancesRequest)this.beforeClientExecution(request);
        return this.executeDescribeRecoveryInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRecoveryInstancesResult executeDescribeRecoveryInstances(DescribeRecoveryInstancesRequest describeRecoveryInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRecoveryInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRecoveryInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRecoveryInstancesRequestProtocolMarshaller(protocolFactory).marshall((DescribeRecoveryInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRecoveryInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRecoveryInstances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRecoveryInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRecoveryInstancesResult describeRecoveryInstancesResult = (DescribeRecoveryInstancesResult)response.getAwsResponse();
            return describeRecoveryInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRecoverySnapshotsResult describeRecoverySnapshots(DescribeRecoverySnapshotsRequest request) {
        request = (DescribeRecoverySnapshotsRequest)this.beforeClientExecution(request);
        return this.executeDescribeRecoverySnapshots(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRecoverySnapshotsResult executeDescribeRecoverySnapshots(DescribeRecoverySnapshotsRequest describeRecoverySnapshotsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRecoverySnapshotsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRecoverySnapshotsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRecoverySnapshotsRequestProtocolMarshaller(protocolFactory).marshall((DescribeRecoverySnapshotsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRecoverySnapshotsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRecoverySnapshots");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRecoverySnapshotsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRecoverySnapshotsResult describeRecoverySnapshotsResult = (DescribeRecoverySnapshotsResult)response.getAwsResponse();
            return describeRecoverySnapshotsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeReplicationConfigurationTemplatesResult describeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesRequest request) {
        request = (DescribeReplicationConfigurationTemplatesRequest)this.beforeClientExecution(request);
        return this.executeDescribeReplicationConfigurationTemplates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeReplicationConfigurationTemplatesResult executeDescribeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeReplicationConfigurationTemplatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeReplicationConfigurationTemplatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeReplicationConfigurationTemplatesRequestProtocolMarshaller(protocolFactory).marshall((DescribeReplicationConfigurationTemplatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeReplicationConfigurationTemplatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeReplicationConfigurationTemplates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeReplicationConfigurationTemplatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeReplicationConfigurationTemplatesResult describeReplicationConfigurationTemplatesResult = (DescribeReplicationConfigurationTemplatesResult)response.getAwsResponse();
            return describeReplicationConfigurationTemplatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSourceServersResult describeSourceServers(DescribeSourceServersRequest request) {
        request = (DescribeSourceServersRequest)this.beforeClientExecution(request);
        return this.executeDescribeSourceServers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSourceServersResult executeDescribeSourceServers(DescribeSourceServersRequest describeSourceServersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSourceServersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSourceServersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSourceServersRequestProtocolMarshaller(protocolFactory).marshall((DescribeSourceServersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSourceServersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSourceServers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSourceServersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSourceServersResult describeSourceServersResult = (DescribeSourceServersResult)response.getAwsResponse();
            return describeSourceServersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisconnectRecoveryInstanceResult disconnectRecoveryInstance(DisconnectRecoveryInstanceRequest request) {
        request = (DisconnectRecoveryInstanceRequest)this.beforeClientExecution(request);
        return this.executeDisconnectRecoveryInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisconnectRecoveryInstanceResult executeDisconnectRecoveryInstance(DisconnectRecoveryInstanceRequest disconnectRecoveryInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disconnectRecoveryInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisconnectRecoveryInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisconnectRecoveryInstanceRequestProtocolMarshaller(protocolFactory).marshall((DisconnectRecoveryInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)disconnectRecoveryInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisconnectRecoveryInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisconnectRecoveryInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisconnectRecoveryInstanceResult disconnectRecoveryInstanceResult = (DisconnectRecoveryInstanceResult)response.getAwsResponse();
            return disconnectRecoveryInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisconnectSourceServerResult disconnectSourceServer(DisconnectSourceServerRequest request) {
        request = (DisconnectSourceServerRequest)this.beforeClientExecution(request);
        return this.executeDisconnectSourceServer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisconnectSourceServerResult executeDisconnectSourceServer(DisconnectSourceServerRequest disconnectSourceServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disconnectSourceServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisconnectSourceServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisconnectSourceServerRequestProtocolMarshaller(protocolFactory).marshall((DisconnectSourceServerRequest)super.beforeMarshalling((AmazonWebServiceRequest)disconnectSourceServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisconnectSourceServer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisconnectSourceServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisconnectSourceServerResult disconnectSourceServerResult = (DisconnectSourceServerResult)response.getAwsResponse();
            return disconnectSourceServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFailbackReplicationConfigurationResult getFailbackReplicationConfiguration(GetFailbackReplicationConfigurationRequest request) {
        request = (GetFailbackReplicationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetFailbackReplicationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFailbackReplicationConfigurationResult executeGetFailbackReplicationConfiguration(GetFailbackReplicationConfigurationRequest getFailbackReplicationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFailbackReplicationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFailbackReplicationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFailbackReplicationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetFailbackReplicationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFailbackReplicationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetFailbackReplicationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFailbackReplicationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFailbackReplicationConfigurationResult getFailbackReplicationConfigurationResult = (GetFailbackReplicationConfigurationResult)response.getAwsResponse();
            return getFailbackReplicationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLaunchConfigurationResult getLaunchConfiguration(GetLaunchConfigurationRequest request) {
        request = (GetLaunchConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetLaunchConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLaunchConfigurationResult executeGetLaunchConfiguration(GetLaunchConfigurationRequest getLaunchConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLaunchConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLaunchConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLaunchConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetLaunchConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLaunchConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLaunchConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLaunchConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLaunchConfigurationResult getLaunchConfigurationResult = (GetLaunchConfigurationResult)response.getAwsResponse();
            return getLaunchConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReplicationConfigurationResult getReplicationConfiguration(GetReplicationConfigurationRequest request) {
        request = (GetReplicationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetReplicationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReplicationConfigurationResult executeGetReplicationConfiguration(GetReplicationConfigurationRequest getReplicationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReplicationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReplicationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReplicationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetReplicationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getReplicationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetReplicationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReplicationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReplicationConfigurationResult getReplicationConfigurationResult = (GetReplicationConfigurationResult)response.getAwsResponse();
            return getReplicationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InitializeServiceResult initializeService(InitializeServiceRequest request) {
        request = (InitializeServiceRequest)this.beforeClientExecution(request);
        return this.executeInitializeService(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InitializeServiceResult executeInitializeService(InitializeServiceRequest initializeServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initializeServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitializeServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitializeServiceRequestProtocolMarshaller(protocolFactory).marshall((InitializeServiceRequest)super.beforeMarshalling((AmazonWebServiceRequest)initializeServiceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InitializeService");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitializeServiceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitializeServiceResult initializeServiceResult = (InitializeServiceResult)response.getAwsResponse();
            return initializeServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListExtensibleSourceServersResult listExtensibleSourceServers(ListExtensibleSourceServersRequest request) {
        request = (ListExtensibleSourceServersRequest)this.beforeClientExecution(request);
        return this.executeListExtensibleSourceServers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListExtensibleSourceServersResult executeListExtensibleSourceServers(ListExtensibleSourceServersRequest listExtensibleSourceServersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listExtensibleSourceServersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListExtensibleSourceServersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListExtensibleSourceServersRequestProtocolMarshaller(protocolFactory).marshall((ListExtensibleSourceServersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listExtensibleSourceServersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListExtensibleSourceServers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListExtensibleSourceServersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListExtensibleSourceServersResult listExtensibleSourceServersResult = (ListExtensibleSourceServersResult)response.getAwsResponse();
            return listExtensibleSourceServersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStagingAccountsResult listStagingAccounts(ListStagingAccountsRequest request) {
        request = (ListStagingAccountsRequest)this.beforeClientExecution(request);
        return this.executeListStagingAccounts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStagingAccountsResult executeListStagingAccounts(ListStagingAccountsRequest listStagingAccountsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStagingAccountsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStagingAccountsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStagingAccountsRequestProtocolMarshaller(protocolFactory).marshall((ListStagingAccountsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listStagingAccountsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListStagingAccounts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListStagingAccountsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStagingAccountsResult listStagingAccountsResult = (ListStagingAccountsResult)response.getAwsResponse();
            return listStagingAccountsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RetryDataReplicationResult retryDataReplication(RetryDataReplicationRequest request) {
        request = (RetryDataReplicationRequest)this.beforeClientExecution(request);
        return this.executeRetryDataReplication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RetryDataReplicationResult executeRetryDataReplication(RetryDataReplicationRequest retryDataReplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(retryDataReplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RetryDataReplicationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RetryDataReplicationRequestProtocolMarshaller(protocolFactory).marshall((RetryDataReplicationRequest)super.beforeMarshalling((AmazonWebServiceRequest)retryDataReplicationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RetryDataReplication");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RetryDataReplicationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RetryDataReplicationResult retryDataReplicationResult = (RetryDataReplicationResult)response.getAwsResponse();
            return retryDataReplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartFailbackLaunchResult startFailbackLaunch(StartFailbackLaunchRequest request) {
        request = (StartFailbackLaunchRequest)this.beforeClientExecution(request);
        return this.executeStartFailbackLaunch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartFailbackLaunchResult executeStartFailbackLaunch(StartFailbackLaunchRequest startFailbackLaunchRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startFailbackLaunchRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartFailbackLaunchRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartFailbackLaunchRequestProtocolMarshaller(protocolFactory).marshall((StartFailbackLaunchRequest)super.beforeMarshalling((AmazonWebServiceRequest)startFailbackLaunchRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartFailbackLaunch");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartFailbackLaunchResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartFailbackLaunchResult startFailbackLaunchResult = (StartFailbackLaunchResult)response.getAwsResponse();
            return startFailbackLaunchResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartRecoveryResult startRecovery(StartRecoveryRequest request) {
        request = (StartRecoveryRequest)this.beforeClientExecution(request);
        return this.executeStartRecovery(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartRecoveryResult executeStartRecovery(StartRecoveryRequest startRecoveryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startRecoveryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartRecoveryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartRecoveryRequestProtocolMarshaller(protocolFactory).marshall((StartRecoveryRequest)super.beforeMarshalling((AmazonWebServiceRequest)startRecoveryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartRecovery");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartRecoveryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartRecoveryResult startRecoveryResult = (StartRecoveryResult)response.getAwsResponse();
            return startRecoveryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopFailbackResult stopFailback(StopFailbackRequest request) {
        request = (StopFailbackRequest)this.beforeClientExecution(request);
        return this.executeStopFailback(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopFailbackResult executeStopFailback(StopFailbackRequest stopFailbackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopFailbackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopFailbackRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopFailbackRequestProtocolMarshaller(protocolFactory).marshall((StopFailbackRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopFailbackRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopFailback");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopFailbackResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopFailbackResult stopFailbackResult = (StopFailbackResult)response.getAwsResponse();
            return stopFailbackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TerminateRecoveryInstancesResult terminateRecoveryInstances(TerminateRecoveryInstancesRequest request) {
        request = (TerminateRecoveryInstancesRequest)this.beforeClientExecution(request);
        return this.executeTerminateRecoveryInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TerminateRecoveryInstancesResult executeTerminateRecoveryInstances(TerminateRecoveryInstancesRequest terminateRecoveryInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(terminateRecoveryInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TerminateRecoveryInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TerminateRecoveryInstancesRequestProtocolMarshaller(protocolFactory).marshall((TerminateRecoveryInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)terminateRecoveryInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TerminateRecoveryInstances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TerminateRecoveryInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TerminateRecoveryInstancesResult terminateRecoveryInstancesResult = (TerminateRecoveryInstancesResult)response.getAwsResponse();
            return terminateRecoveryInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFailbackReplicationConfigurationResult updateFailbackReplicationConfiguration(UpdateFailbackReplicationConfigurationRequest request) {
        request = (UpdateFailbackReplicationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateFailbackReplicationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFailbackReplicationConfigurationResult executeUpdateFailbackReplicationConfiguration(UpdateFailbackReplicationConfigurationRequest updateFailbackReplicationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFailbackReplicationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFailbackReplicationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFailbackReplicationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateFailbackReplicationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateFailbackReplicationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateFailbackReplicationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateFailbackReplicationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFailbackReplicationConfigurationResult updateFailbackReplicationConfigurationResult = (UpdateFailbackReplicationConfigurationResult)response.getAwsResponse();
            return updateFailbackReplicationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateLaunchConfigurationResult updateLaunchConfiguration(UpdateLaunchConfigurationRequest request) {
        request = (UpdateLaunchConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateLaunchConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateLaunchConfigurationResult executeUpdateLaunchConfiguration(UpdateLaunchConfigurationRequest updateLaunchConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateLaunchConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateLaunchConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateLaunchConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateLaunchConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateLaunchConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateLaunchConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateLaunchConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateLaunchConfigurationResult updateLaunchConfigurationResult = (UpdateLaunchConfigurationResult)response.getAwsResponse();
            return updateLaunchConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateReplicationConfigurationResult updateReplicationConfiguration(UpdateReplicationConfigurationRequest request) {
        request = (UpdateReplicationConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateReplicationConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateReplicationConfigurationResult executeUpdateReplicationConfiguration(UpdateReplicationConfigurationRequest updateReplicationConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateReplicationConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateReplicationConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateReplicationConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateReplicationConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateReplicationConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateReplicationConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateReplicationConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateReplicationConfigurationResult updateReplicationConfigurationResult = (UpdateReplicationConfigurationResult)response.getAwsResponse();
            return updateReplicationConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateReplicationConfigurationTemplateResult updateReplicationConfigurationTemplate(UpdateReplicationConfigurationTemplateRequest request) {
        request = (UpdateReplicationConfigurationTemplateRequest)this.beforeClientExecution(request);
        return this.executeUpdateReplicationConfigurationTemplate(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateReplicationConfigurationTemplateResult executeUpdateReplicationConfigurationTemplate(UpdateReplicationConfigurationTemplateRequest updateReplicationConfigurationTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateReplicationConfigurationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateReplicationConfigurationTemplateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateReplicationConfigurationTemplateRequestProtocolMarshaller(protocolFactory).marshall((UpdateReplicationConfigurationTemplateRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateReplicationConfigurationTemplateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateReplicationConfigurationTemplate");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateReplicationConfigurationTemplateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateReplicationConfigurationTemplateResult updateReplicationConfigurationTemplateResult = (UpdateReplicationConfigurationTemplateResult)response.getAwsResponse();
            return updateReplicationConfigurationTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

