/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CancelSpotFleetRequestsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CancelSpotFleetRequestsRequestMarshaller
implements Marshaller<Request<CancelSpotFleetRequestsRequest>, CancelSpotFleetRequestsRequest> {
    public Request<CancelSpotFleetRequestsRequest> marshall(CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest) {
        if (cancelSpotFleetRequestsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cancelSpotFleetRequestsRequest, "AmazonEC2");
        request.addParameter("Action", "CancelSpotFleetRequests");
        request.addParameter("Version", "2015-04-15");
        List<String> spotFleetRequestIdsList = cancelSpotFleetRequestsRequest.getSpotFleetRequestIds();
        int spotFleetRequestIdsListIndex = 1;
        for (String spotFleetRequestIdsListValue : spotFleetRequestIdsList) {
            if (spotFleetRequestIdsListValue != null) {
                request.addParameter("SpotFleetRequestId." + spotFleetRequestIdsListIndex, StringUtils.fromString((String)spotFleetRequestIdsListValue));
            }
            ++spotFleetRequestIdsListIndex;
        }
        if (cancelSpotFleetRequestsRequest.isTerminateInstances() != null) {
            request.addParameter("TerminateInstances", StringUtils.fromBoolean((Boolean)cancelSpotFleetRequestsRequest.isTerminateInstances()));
        }
        return request;
    }
}

