/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AcceleratorCountRequest;
import com.amazonaws.services.ec2.model.AcceleratorTotalMemoryMiBRequest;
import com.amazonaws.services.ec2.model.BaselineEbsBandwidthMbpsRequest;
import com.amazonaws.services.ec2.model.CapacityReservationTarget;
import com.amazonaws.services.ec2.model.CreateLaunchTemplateVersionRequest;
import com.amazonaws.services.ec2.model.CreditSpecificationRequest;
import com.amazonaws.services.ec2.model.ElasticGpuSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6AddressRequest;
import com.amazonaws.services.ec2.model.InstanceRequirementsRequest;
import com.amazonaws.services.ec2.model.Ipv4PrefixSpecificationRequest;
import com.amazonaws.services.ec2.model.Ipv6PrefixSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateCpuOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateEbsBlockDeviceRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateElasticInferenceAccelerator;
import com.amazonaws.services.ec2.model.LaunchTemplateEnclaveOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateHibernationOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateLicenseConfigurationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplatePlacementRequest;
import com.amazonaws.services.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateSpotMarketOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateTagSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplatesMonitoringRequest;
import com.amazonaws.services.ec2.model.MemoryGiBPerVCpuRequest;
import com.amazonaws.services.ec2.model.MemoryMiBRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceCountRequest;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestLaunchTemplateData;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TotalLocalStorageGBRequest;
import com.amazonaws.services.ec2.model.VCpuCountRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.Iterator;

public class CreateLaunchTemplateVersionRequestMarshaller
implements Marshaller<Request<CreateLaunchTemplateVersionRequest>, CreateLaunchTemplateVersionRequest> {
    public Request<CreateLaunchTemplateVersionRequest> marshall(CreateLaunchTemplateVersionRequest createLaunchTemplateVersionRequest) {
        RequestLaunchTemplateData launchTemplateData;
        if (createLaunchTemplateVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLaunchTemplateVersionRequest, "AmazonEC2");
        request.addParameter("Action", "CreateLaunchTemplateVersion");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLaunchTemplateVersionRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createLaunchTemplateVersionRequest.getClientToken()));
        }
        if (createLaunchTemplateVersionRequest.getLaunchTemplateId() != null) {
            request.addParameter("LaunchTemplateId", StringUtils.fromString((String)createLaunchTemplateVersionRequest.getLaunchTemplateId()));
        }
        if (createLaunchTemplateVersionRequest.getLaunchTemplateName() != null) {
            request.addParameter("LaunchTemplateName", StringUtils.fromString((String)createLaunchTemplateVersionRequest.getLaunchTemplateName()));
        }
        if (createLaunchTemplateVersionRequest.getSourceVersion() != null) {
            request.addParameter("SourceVersion", StringUtils.fromString((String)createLaunchTemplateVersionRequest.getSourceVersion()));
        }
        if (createLaunchTemplateVersionRequest.getVersionDescription() != null) {
            request.addParameter("VersionDescription", StringUtils.fromString((String)createLaunchTemplateVersionRequest.getVersionDescription()));
        }
        if ((launchTemplateData = createLaunchTemplateVersionRequest.getLaunchTemplateData()) != null) {
            LaunchTemplatePrivateDnsNameOptionsRequest privateDnsNameOptions;
            InstanceRequirementsRequest instanceRequirements;
            LaunchTemplateEnclaveOptionsRequest enclaveOptions;
            LaunchTemplateInstanceMetadataOptionsRequest metadataOptions;
            LaunchTemplateHibernationOptionsRequest hibernationOptions;
            SdkInternalList requestLaunchTemplateDataLicenseSpecificationsList;
            LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;
            LaunchTemplateCpuOptionsRequest cpuOptions;
            CreditSpecificationRequest creditSpecification;
            LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;
            SdkInternalList requestLaunchTemplateDataSecurityGroupsList;
            SdkInternalList requestLaunchTemplateDataSecurityGroupIdsList;
            SdkInternalList requestLaunchTemplateDataElasticInferenceAcceleratorsList;
            SdkInternalList requestLaunchTemplateDataElasticGpuSpecificationsList;
            SdkInternalList requestLaunchTemplateDataTagSpecificationsList;
            LaunchTemplatePlacementRequest placement;
            LaunchTemplatesMonitoringRequest monitoring;
            SdkInternalList requestLaunchTemplateDataNetworkInterfacesList;
            SdkInternalList requestLaunchTemplateDataBlockDeviceMappingsList;
            LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;
            if (launchTemplateData.getKernelId() != null) {
                request.addParameter("LaunchTemplateData.KernelId", StringUtils.fromString((String)launchTemplateData.getKernelId()));
            }
            if (launchTemplateData.getEbsOptimized() != null) {
                request.addParameter("LaunchTemplateData.EbsOptimized", StringUtils.fromBoolean((Boolean)launchTemplateData.getEbsOptimized()));
            }
            if ((iamInstanceProfile = launchTemplateData.getIamInstanceProfile()) != null) {
                if (iamInstanceProfile.getArn() != null) {
                    request.addParameter("LaunchTemplateData.IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
                }
                if (iamInstanceProfile.getName() != null) {
                    request.addParameter("LaunchTemplateData.IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
                }
            }
            if (!(requestLaunchTemplateDataBlockDeviceMappingsList = (SdkInternalList)launchTemplateData.getBlockDeviceMappings()).isEmpty() || !requestLaunchTemplateDataBlockDeviceMappingsList.isAutoConstruct()) {
                int blockDeviceMappingsListIndex = 1;
                for (Object requestLaunchTemplateDataBlockDeviceMappingsListValue : requestLaunchTemplateDataBlockDeviceMappingsList) {
                    LaunchTemplateEbsBlockDeviceRequest ebs;
                    if (((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getDeviceName() != null) {
                        request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getDeviceName()));
                    }
                    if (((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getVirtualName() != null) {
                        request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getVirtualName()));
                    }
                    if ((ebs = ((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getEbs()) != null) {
                        if (ebs.getEncrypted() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                        }
                        if (ebs.getDeleteOnTermination() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                        }
                        if (ebs.getIops() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                        }
                        if (ebs.getKmsKeyId() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString((String)ebs.getKmsKeyId()));
                        }
                        if (ebs.getSnapshotId() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                        }
                        if (ebs.getVolumeSize() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                        }
                        if (ebs.getVolumeType() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                        }
                        if (ebs.getThroughput() != null) {
                            request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Throughput", StringUtils.fromInteger((Integer)ebs.getThroughput()));
                        }
                    }
                    if (((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getNoDevice() != null) {
                        request.addParameter("LaunchTemplateData.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)((LaunchTemplateBlockDeviceMappingRequest)requestLaunchTemplateDataBlockDeviceMappingsListValue).getNoDevice()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataNetworkInterfacesList = (SdkInternalList)launchTemplateData.getNetworkInterfaces()).isEmpty() || !requestLaunchTemplateDataNetworkInterfacesList.isAutoConstruct()) {
                int networkInterfacesListIndex = 1;
                for (LaunchTemplateInstanceNetworkInterfaceSpecificationRequest requestLaunchTemplateDataNetworkInterfacesListValue : requestLaunchTemplateDataNetworkInterfacesList) {
                    SdkInternalList launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6PrefixesList;
                    SdkInternalList launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv4PrefixesList;
                    SdkInternalList launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList;
                    Iterator launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList;
                    SdkInternalList launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList;
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getAssociateCarrierIpAddress() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".AssociateCarrierIpAddress", StringUtils.fromBoolean((Boolean)requestLaunchTemplateDataNetworkInterfacesListValue.getAssociateCarrierIpAddress()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)requestLaunchTemplateDataNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)requestLaunchTemplateDataNetworkInterfacesListValue.getDeleteOnTermination()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getDescription() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)requestLaunchTemplateDataNetworkInterfacesListValue.getDescription()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getDeviceIndex() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)requestLaunchTemplateDataNetworkInterfacesListValue.getDeviceIndex()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList = (SdkInternalList)requestLaunchTemplateDataNetworkInterfacesListValue.getGroups()).isEmpty() || !launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList.isAutoConstruct()) {
                        int groupsListIndex = 1;
                        for (Object launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue : launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsList) {
                            if (launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getInterfaceType() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".InterfaceType", StringUtils.fromString((String)requestLaunchTemplateDataNetworkInterfacesListValue.getInterfaceType()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger((Integer)requestLaunchTemplateDataNetworkInterfacesListValue.getIpv6AddressCount()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList = (SdkInternalList)requestLaunchTemplateDataNetworkInterfacesListValue.getIpv6Addresses()).isEmpty() || !launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList.isAutoConstruct()) {
                        Object launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue;
                        int ipv6AddressesListIndex = 1;
                        launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue = launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesList.iterator();
                        while (launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue.hasNext()) {
                            InstanceIpv6AddressRequest launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesListValue = (InstanceIpv6AddressRequest)launchTemplateInstanceNetworkInterfaceSpecificationRequestGroupsListValue.next();
                            if (launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesListValue.getIpv6Address() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6AddressesListValue.getIpv6Address()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)requestLaunchTemplateDataNetworkInterfacesListValue.getNetworkInterfaceId()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)requestLaunchTemplateDataNetworkInterfacesListValue.getPrivateIpAddress()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList = (SdkInternalList)requestLaunchTemplateDataNetworkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList.isAutoConstruct()) {
                        int privateIpAddressesListIndex = 1;
                        for (Object launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue : launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesList) {
                            if (((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).getPrimary() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).getPrimary()));
                            }
                            if (((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).getPrivateIpAddress() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)((PrivateIpAddressSpecification)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue).getPrivateIpAddress()));
                            }
                            ++privateIpAddressesListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)requestLaunchTemplateDataNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getSubnetId() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)requestLaunchTemplateDataNetworkInterfacesListValue.getSubnetId()));
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getNetworkCardIndex() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".NetworkCardIndex", StringUtils.fromInteger((Integer)requestLaunchTemplateDataNetworkInterfacesListValue.getNetworkCardIndex()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv4PrefixesList = (SdkInternalList)requestLaunchTemplateDataNetworkInterfacesListValue.getIpv4Prefixes()).isEmpty() || !launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv4PrefixesList.isAutoConstruct()) {
                        Object launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue;
                        int ipv4PrefixesListIndex = 1;
                        launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue = launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv4PrefixesList.iterator();
                        while (launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue.hasNext()) {
                            Ipv4PrefixSpecificationRequest launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv4PrefixesListValue = (Ipv4PrefixSpecificationRequest)launchTemplateInstanceNetworkInterfaceSpecificationRequestPrivateIpAddressesListValue.next();
                            if (launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv4PrefixesListValue.getIpv4Prefix() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv4Prefix." + ipv4PrefixesListIndex + ".Ipv4Prefix", StringUtils.fromString((String)launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv4PrefixesListValue.getIpv4Prefix()));
                            }
                            ++ipv4PrefixesListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getIpv4PrefixCount() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv4PrefixCount", StringUtils.fromInteger((Integer)requestLaunchTemplateDataNetworkInterfacesListValue.getIpv4PrefixCount()));
                    }
                    if (!(launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6PrefixesList = (SdkInternalList)requestLaunchTemplateDataNetworkInterfacesListValue.getIpv6Prefixes()).isEmpty() || !launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6PrefixesList.isAutoConstruct()) {
                        int ipv6PrefixesListIndex = 1;
                        for (Ipv6PrefixSpecificationRequest launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6PrefixesListValue : launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6PrefixesList) {
                            if (launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6PrefixesListValue.getIpv6Prefix() != null) {
                                request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Prefix." + ipv6PrefixesListIndex + ".Ipv6Prefix", StringUtils.fromString((String)launchTemplateInstanceNetworkInterfaceSpecificationRequestIpv6PrefixesListValue.getIpv6Prefix()));
                            }
                            ++ipv6PrefixesListIndex;
                        }
                    }
                    if (requestLaunchTemplateDataNetworkInterfacesListValue.getIpv6PrefixCount() != null) {
                        request.addParameter("LaunchTemplateData.NetworkInterface." + networkInterfacesListIndex + ".Ipv6PrefixCount", StringUtils.fromInteger((Integer)requestLaunchTemplateDataNetworkInterfacesListValue.getIpv6PrefixCount()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if (launchTemplateData.getImageId() != null) {
                request.addParameter("LaunchTemplateData.ImageId", StringUtils.fromString((String)launchTemplateData.getImageId()));
            }
            if (launchTemplateData.getInstanceType() != null) {
                request.addParameter("LaunchTemplateData.InstanceType", StringUtils.fromString((String)launchTemplateData.getInstanceType()));
            }
            if (launchTemplateData.getKeyName() != null) {
                request.addParameter("LaunchTemplateData.KeyName", StringUtils.fromString((String)launchTemplateData.getKeyName()));
            }
            if ((monitoring = launchTemplateData.getMonitoring()) != null && monitoring.getEnabled() != null) {
                request.addParameter("LaunchTemplateData.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)monitoring.getEnabled()));
            }
            if ((placement = launchTemplateData.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchTemplateData.Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                }
                if (placement.getAffinity() != null) {
                    request.addParameter("LaunchTemplateData.Placement.Affinity", StringUtils.fromString((String)placement.getAffinity()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchTemplateData.Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                }
                if (placement.getHostId() != null) {
                    request.addParameter("LaunchTemplateData.Placement.HostId", StringUtils.fromString((String)placement.getHostId()));
                }
                if (placement.getTenancy() != null) {
                    request.addParameter("LaunchTemplateData.Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
                }
                if (placement.getSpreadDomain() != null) {
                    request.addParameter("LaunchTemplateData.Placement.SpreadDomain", StringUtils.fromString((String)placement.getSpreadDomain()));
                }
                if (placement.getHostResourceGroupArn() != null) {
                    request.addParameter("LaunchTemplateData.Placement.HostResourceGroupArn", StringUtils.fromString((String)placement.getHostResourceGroupArn()));
                }
                if (placement.getPartitionNumber() != null) {
                    request.addParameter("LaunchTemplateData.Placement.PartitionNumber", StringUtils.fromInteger((Integer)placement.getPartitionNumber()));
                }
            }
            if (launchTemplateData.getRamDiskId() != null) {
                request.addParameter("LaunchTemplateData.RamDiskId", StringUtils.fromString((String)launchTemplateData.getRamDiskId()));
            }
            if (launchTemplateData.getDisableApiTermination() != null) {
                request.addParameter("LaunchTemplateData.DisableApiTermination", StringUtils.fromBoolean((Boolean)launchTemplateData.getDisableApiTermination()));
            }
            if (launchTemplateData.getInstanceInitiatedShutdownBehavior() != null) {
                request.addParameter("LaunchTemplateData.InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)launchTemplateData.getInstanceInitiatedShutdownBehavior()));
            }
            if (launchTemplateData.getUserData() != null) {
                request.addParameter("LaunchTemplateData.UserData", StringUtils.fromString((String)launchTemplateData.getUserData()));
            }
            if (!(requestLaunchTemplateDataTagSpecificationsList = (SdkInternalList)launchTemplateData.getTagSpecifications()).isEmpty() || !requestLaunchTemplateDataTagSpecificationsList.isAutoConstruct()) {
                int tagSpecificationsListIndex = 1;
                for (Object requestLaunchTemplateDataTagSpecificationsListValue : requestLaunchTemplateDataTagSpecificationsList) {
                    SdkInternalList launchTemplateTagSpecificationRequestTagsList;
                    if (((LaunchTemplateTagSpecificationRequest)requestLaunchTemplateDataTagSpecificationsListValue).getResourceType() != null) {
                        request.addParameter("LaunchTemplateData.TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)((LaunchTemplateTagSpecificationRequest)requestLaunchTemplateDataTagSpecificationsListValue).getResourceType()));
                    }
                    if (!(launchTemplateTagSpecificationRequestTagsList = (SdkInternalList)((LaunchTemplateTagSpecificationRequest)requestLaunchTemplateDataTagSpecificationsListValue).getTags()).isEmpty() || !launchTemplateTagSpecificationRequestTagsList.isAutoConstruct()) {
                        int tagsListIndex = 1;
                        for (Tag launchTemplateTagSpecificationRequestTagsListValue : launchTemplateTagSpecificationRequestTagsList) {
                            if (launchTemplateTagSpecificationRequestTagsListValue.getKey() != null) {
                                request.addParameter("LaunchTemplateData.TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)launchTemplateTagSpecificationRequestTagsListValue.getKey()));
                            }
                            if (launchTemplateTagSpecificationRequestTagsListValue.getValue() != null) {
                                request.addParameter("LaunchTemplateData.TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)launchTemplateTagSpecificationRequestTagsListValue.getValue()));
                            }
                            ++tagsListIndex;
                        }
                    }
                    ++tagSpecificationsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataElasticGpuSpecificationsList = (SdkInternalList)launchTemplateData.getElasticGpuSpecifications()).isEmpty() || !requestLaunchTemplateDataElasticGpuSpecificationsList.isAutoConstruct()) {
                int elasticGpuSpecificationsListIndex = 1;
                for (Object requestLaunchTemplateDataElasticGpuSpecificationsListValue : requestLaunchTemplateDataElasticGpuSpecificationsList) {
                    if (((ElasticGpuSpecification)requestLaunchTemplateDataElasticGpuSpecificationsListValue).getType() != null) {
                        request.addParameter("LaunchTemplateData.ElasticGpuSpecification." + elasticGpuSpecificationsListIndex + ".Type", StringUtils.fromString((String)((ElasticGpuSpecification)requestLaunchTemplateDataElasticGpuSpecificationsListValue).getType()));
                    }
                    ++elasticGpuSpecificationsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataElasticInferenceAcceleratorsList = (SdkInternalList)launchTemplateData.getElasticInferenceAccelerators()).isEmpty() || !requestLaunchTemplateDataElasticInferenceAcceleratorsList.isAutoConstruct()) {
                int elasticInferenceAcceleratorsListIndex = 1;
                for (LaunchTemplateElasticInferenceAccelerator requestLaunchTemplateDataElasticInferenceAcceleratorsListValue : requestLaunchTemplateDataElasticInferenceAcceleratorsList) {
                    if (requestLaunchTemplateDataElasticInferenceAcceleratorsListValue.getType() != null) {
                        request.addParameter("LaunchTemplateData.ElasticInferenceAccelerator." + elasticInferenceAcceleratorsListIndex + ".Type", StringUtils.fromString((String)requestLaunchTemplateDataElasticInferenceAcceleratorsListValue.getType()));
                    }
                    if (requestLaunchTemplateDataElasticInferenceAcceleratorsListValue.getCount() != null) {
                        request.addParameter("LaunchTemplateData.ElasticInferenceAccelerator." + elasticInferenceAcceleratorsListIndex + ".Count", StringUtils.fromInteger((Integer)requestLaunchTemplateDataElasticInferenceAcceleratorsListValue.getCount()));
                    }
                    ++elasticInferenceAcceleratorsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataSecurityGroupIdsList = (SdkInternalList)launchTemplateData.getSecurityGroupIds()).isEmpty() || !requestLaunchTemplateDataSecurityGroupIdsList.isAutoConstruct()) {
                int securityGroupIdsListIndex = 1;
                for (String requestLaunchTemplateDataSecurityGroupIdsListValue : requestLaunchTemplateDataSecurityGroupIdsList) {
                    if (requestLaunchTemplateDataSecurityGroupIdsListValue != null) {
                        request.addParameter("LaunchTemplateData.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)requestLaunchTemplateDataSecurityGroupIdsListValue));
                    }
                    ++securityGroupIdsListIndex;
                }
            }
            if (!(requestLaunchTemplateDataSecurityGroupsList = (SdkInternalList)launchTemplateData.getSecurityGroups()).isEmpty() || !requestLaunchTemplateDataSecurityGroupsList.isAutoConstruct()) {
                int securityGroupsListIndex = 1;
                for (String requestLaunchTemplateDataSecurityGroupsListValue : requestLaunchTemplateDataSecurityGroupsList) {
                    if (requestLaunchTemplateDataSecurityGroupsListValue != null) {
                        request.addParameter("LaunchTemplateData.SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)requestLaunchTemplateDataSecurityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
            if ((instanceMarketOptions = launchTemplateData.getInstanceMarketOptions()) != null) {
                LaunchTemplateSpotMarketOptionsRequest spotOptions;
                if (instanceMarketOptions.getMarketType() != null) {
                    request.addParameter("LaunchTemplateData.InstanceMarketOptions.MarketType", StringUtils.fromString((String)instanceMarketOptions.getMarketType()));
                }
                if ((spotOptions = instanceMarketOptions.getSpotOptions()) != null) {
                    if (spotOptions.getMaxPrice() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.MaxPrice", StringUtils.fromString((String)spotOptions.getMaxPrice()));
                    }
                    if (spotOptions.getSpotInstanceType() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.SpotInstanceType", StringUtils.fromString((String)spotOptions.getSpotInstanceType()));
                    }
                    if (spotOptions.getBlockDurationMinutes() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.BlockDurationMinutes", StringUtils.fromInteger((Integer)spotOptions.getBlockDurationMinutes()));
                    }
                    if (spotOptions.getValidUntil() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.ValidUntil", StringUtils.fromDate((Date)spotOptions.getValidUntil()));
                    }
                    if (spotOptions.getInstanceInterruptionBehavior() != null) {
                        request.addParameter("LaunchTemplateData.InstanceMarketOptions.SpotOptions.InstanceInterruptionBehavior", StringUtils.fromString((String)spotOptions.getInstanceInterruptionBehavior()));
                    }
                }
            }
            if ((creditSpecification = launchTemplateData.getCreditSpecification()) != null && creditSpecification.getCpuCredits() != null) {
                request.addParameter("LaunchTemplateData.CreditSpecification.CpuCredits", StringUtils.fromString((String)creditSpecification.getCpuCredits()));
            }
            if ((cpuOptions = launchTemplateData.getCpuOptions()) != null) {
                if (cpuOptions.getCoreCount() != null) {
                    request.addParameter("LaunchTemplateData.CpuOptions.CoreCount", StringUtils.fromInteger((Integer)cpuOptions.getCoreCount()));
                }
                if (cpuOptions.getThreadsPerCore() != null) {
                    request.addParameter("LaunchTemplateData.CpuOptions.ThreadsPerCore", StringUtils.fromInteger((Integer)cpuOptions.getThreadsPerCore()));
                }
            }
            if ((capacityReservationSpecification = launchTemplateData.getCapacityReservationSpecification()) != null) {
                CapacityReservationTarget capacityReservationTarget;
                if (capacityReservationSpecification.getCapacityReservationPreference() != null) {
                    request.addParameter("LaunchTemplateData.CapacityReservationSpecification.CapacityReservationPreference", StringUtils.fromString((String)capacityReservationSpecification.getCapacityReservationPreference()));
                }
                if ((capacityReservationTarget = capacityReservationSpecification.getCapacityReservationTarget()) != null) {
                    if (capacityReservationTarget.getCapacityReservationId() != null) {
                        request.addParameter("LaunchTemplateData.CapacityReservationSpecification.CapacityReservationTarget.CapacityReservationId", StringUtils.fromString((String)capacityReservationTarget.getCapacityReservationId()));
                    }
                    if (capacityReservationTarget.getCapacityReservationResourceGroupArn() != null) {
                        request.addParameter("LaunchTemplateData.CapacityReservationSpecification.CapacityReservationTarget.CapacityReservationResourceGroupArn", StringUtils.fromString((String)capacityReservationTarget.getCapacityReservationResourceGroupArn()));
                    }
                }
            }
            if (!(requestLaunchTemplateDataLicenseSpecificationsList = (SdkInternalList)launchTemplateData.getLicenseSpecifications()).isEmpty() || !requestLaunchTemplateDataLicenseSpecificationsList.isAutoConstruct()) {
                int licenseSpecificationsListIndex = 1;
                for (LaunchTemplateLicenseConfigurationRequest requestLaunchTemplateDataLicenseSpecificationsListValue : requestLaunchTemplateDataLicenseSpecificationsList) {
                    if (requestLaunchTemplateDataLicenseSpecificationsListValue.getLicenseConfigurationArn() != null) {
                        request.addParameter("LaunchTemplateData.LicenseSpecification." + licenseSpecificationsListIndex + ".LicenseConfigurationArn", StringUtils.fromString((String)requestLaunchTemplateDataLicenseSpecificationsListValue.getLicenseConfigurationArn()));
                    }
                    ++licenseSpecificationsListIndex;
                }
            }
            if ((hibernationOptions = launchTemplateData.getHibernationOptions()) != null && hibernationOptions.getConfigured() != null) {
                request.addParameter("LaunchTemplateData.HibernationOptions.Configured", StringUtils.fromBoolean((Boolean)hibernationOptions.getConfigured()));
            }
            if ((metadataOptions = launchTemplateData.getMetadataOptions()) != null) {
                if (metadataOptions.getHttpTokens() != null) {
                    request.addParameter("LaunchTemplateData.MetadataOptions.HttpTokens", StringUtils.fromString((String)metadataOptions.getHttpTokens()));
                }
                if (metadataOptions.getHttpPutResponseHopLimit() != null) {
                    request.addParameter("LaunchTemplateData.MetadataOptions.HttpPutResponseHopLimit", StringUtils.fromInteger((Integer)metadataOptions.getHttpPutResponseHopLimit()));
                }
                if (metadataOptions.getHttpEndpoint() != null) {
                    request.addParameter("LaunchTemplateData.MetadataOptions.HttpEndpoint", StringUtils.fromString((String)metadataOptions.getHttpEndpoint()));
                }
                if (metadataOptions.getHttpProtocolIpv6() != null) {
                    request.addParameter("LaunchTemplateData.MetadataOptions.HttpProtocolIpv6", StringUtils.fromString((String)metadataOptions.getHttpProtocolIpv6()));
                }
            }
            if ((enclaveOptions = launchTemplateData.getEnclaveOptions()) != null && enclaveOptions.getEnabled() != null) {
                request.addParameter("LaunchTemplateData.EnclaveOptions.Enabled", StringUtils.fromBoolean((Boolean)enclaveOptions.getEnabled()));
            }
            if ((instanceRequirements = launchTemplateData.getInstanceRequirements()) != null) {
                AcceleratorTotalMemoryMiBRequest acceleratorTotalMemoryMiB;
                SdkInternalList instanceRequirementsRequestAcceleratorNamesList;
                SdkInternalList instanceRequirementsRequestAcceleratorManufacturersList;
                AcceleratorCountRequest acceleratorCount;
                SdkInternalList instanceRequirementsRequestAcceleratorTypesList;
                BaselineEbsBandwidthMbpsRequest baselineEbsBandwidthMbps;
                TotalLocalStorageGBRequest totalLocalStorageGB;
                SdkInternalList instanceRequirementsRequestLocalStorageTypesList;
                NetworkInterfaceCountRequest networkInterfaceCount;
                SdkInternalList instanceRequirementsRequestInstanceGenerationsList;
                SdkInternalList instanceRequirementsRequestExcludedInstanceTypesList;
                MemoryGiBPerVCpuRequest memoryGiBPerVCpu;
                SdkInternalList instanceRequirementsRequestCpuManufacturersList;
                MemoryMiBRequest memoryMiB;
                VCpuCountRangeRequest vCpuCount = instanceRequirements.getVCpuCount();
                if (vCpuCount != null) {
                    if (vCpuCount.getMin() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.VCpuCount.Min", StringUtils.fromInteger((Integer)vCpuCount.getMin()));
                    }
                    if (vCpuCount.getMax() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.VCpuCount.Max", StringUtils.fromInteger((Integer)vCpuCount.getMax()));
                    }
                }
                if ((memoryMiB = instanceRequirements.getMemoryMiB()) != null) {
                    if (memoryMiB.getMin() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.MemoryMiB.Min", StringUtils.fromInteger((Integer)memoryMiB.getMin()));
                    }
                    if (memoryMiB.getMax() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.MemoryMiB.Max", StringUtils.fromInteger((Integer)memoryMiB.getMax()));
                    }
                }
                if (!(instanceRequirementsRequestCpuManufacturersList = (SdkInternalList)instanceRequirements.getCpuManufacturers()).isEmpty() || !instanceRequirementsRequestCpuManufacturersList.isAutoConstruct()) {
                    int cpuManufacturersListIndex = 1;
                    for (String instanceRequirementsRequestCpuManufacturersListValue : instanceRequirementsRequestCpuManufacturersList) {
                        if (instanceRequirementsRequestCpuManufacturersListValue != null) {
                            request.addParameter("LaunchTemplateData.InstanceRequirements.CpuManufacturer." + cpuManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsRequestCpuManufacturersListValue));
                        }
                        ++cpuManufacturersListIndex;
                    }
                }
                if ((memoryGiBPerVCpu = instanceRequirements.getMemoryGiBPerVCpu()) != null) {
                    if (memoryGiBPerVCpu.getMin() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.MemoryGiBPerVCpu.Min", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMin()));
                    }
                    if (memoryGiBPerVCpu.getMax() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.MemoryGiBPerVCpu.Max", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMax()));
                    }
                }
                if (!(instanceRequirementsRequestExcludedInstanceTypesList = (SdkInternalList)instanceRequirements.getExcludedInstanceTypes()).isEmpty() || !instanceRequirementsRequestExcludedInstanceTypesList.isAutoConstruct()) {
                    int excludedInstanceTypesListIndex = 1;
                    for (Object instanceRequirementsRequestExcludedInstanceTypesListValue : instanceRequirementsRequestExcludedInstanceTypesList) {
                        if (instanceRequirementsRequestExcludedInstanceTypesListValue != null) {
                            request.addParameter("LaunchTemplateData.InstanceRequirements.ExcludedInstanceType." + excludedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestExcludedInstanceTypesListValue));
                        }
                        ++excludedInstanceTypesListIndex;
                    }
                }
                if (!(instanceRequirementsRequestInstanceGenerationsList = (SdkInternalList)instanceRequirements.getInstanceGenerations()).isEmpty() || !instanceRequirementsRequestInstanceGenerationsList.isAutoConstruct()) {
                    int instanceGenerationsListIndex = 1;
                    for (String instanceRequirementsRequestInstanceGenerationsListValue : instanceRequirementsRequestInstanceGenerationsList) {
                        if (instanceRequirementsRequestInstanceGenerationsListValue != null) {
                            request.addParameter("LaunchTemplateData.InstanceRequirements.InstanceGeneration." + instanceGenerationsListIndex, StringUtils.fromString((String)instanceRequirementsRequestInstanceGenerationsListValue));
                        }
                        ++instanceGenerationsListIndex;
                    }
                }
                if (instanceRequirements.getSpotMaxPricePercentageOverLowestPrice() != null) {
                    request.addParameter("LaunchTemplateData.InstanceRequirements.SpotMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getSpotMaxPricePercentageOverLowestPrice()));
                }
                if (instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                    request.addParameter("LaunchTemplateData.InstanceRequirements.OnDemandMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice()));
                }
                if (instanceRequirements.getBareMetal() != null) {
                    request.addParameter("LaunchTemplateData.InstanceRequirements.BareMetal", StringUtils.fromString((String)instanceRequirements.getBareMetal()));
                }
                if (instanceRequirements.getBurstablePerformance() != null) {
                    request.addParameter("LaunchTemplateData.InstanceRequirements.BurstablePerformance", StringUtils.fromString((String)instanceRequirements.getBurstablePerformance()));
                }
                if (instanceRequirements.getRequireHibernateSupport() != null) {
                    request.addParameter("LaunchTemplateData.InstanceRequirements.RequireHibernateSupport", StringUtils.fromBoolean((Boolean)instanceRequirements.getRequireHibernateSupport()));
                }
                if ((networkInterfaceCount = instanceRequirements.getNetworkInterfaceCount()) != null) {
                    if (networkInterfaceCount.getMin() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.NetworkInterfaceCount.Min", StringUtils.fromInteger((Integer)networkInterfaceCount.getMin()));
                    }
                    if (networkInterfaceCount.getMax() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.NetworkInterfaceCount.Max", StringUtils.fromInteger((Integer)networkInterfaceCount.getMax()));
                    }
                }
                if (instanceRequirements.getLocalStorage() != null) {
                    request.addParameter("LaunchTemplateData.InstanceRequirements.LocalStorage", StringUtils.fromString((String)instanceRequirements.getLocalStorage()));
                }
                if (!(instanceRequirementsRequestLocalStorageTypesList = (SdkInternalList)instanceRequirements.getLocalStorageTypes()).isEmpty() || !instanceRequirementsRequestLocalStorageTypesList.isAutoConstruct()) {
                    int localStorageTypesListIndex = 1;
                    for (String instanceRequirementsRequestLocalStorageTypesListValue : instanceRequirementsRequestLocalStorageTypesList) {
                        if (instanceRequirementsRequestLocalStorageTypesListValue != null) {
                            request.addParameter("LaunchTemplateData.InstanceRequirements.LocalStorageType." + localStorageTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestLocalStorageTypesListValue));
                        }
                        ++localStorageTypesListIndex;
                    }
                }
                if ((totalLocalStorageGB = instanceRequirements.getTotalLocalStorageGB()) != null) {
                    if (totalLocalStorageGB.getMin() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.TotalLocalStorageGB.Min", StringUtils.fromDouble((Double)totalLocalStorageGB.getMin()));
                    }
                    if (totalLocalStorageGB.getMax() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.TotalLocalStorageGB.Max", StringUtils.fromDouble((Double)totalLocalStorageGB.getMax()));
                    }
                }
                if ((baselineEbsBandwidthMbps = instanceRequirements.getBaselineEbsBandwidthMbps()) != null) {
                    if (baselineEbsBandwidthMbps.getMin() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.BaselineEbsBandwidthMbps.Min", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMin()));
                    }
                    if (baselineEbsBandwidthMbps.getMax() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.BaselineEbsBandwidthMbps.Max", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMax()));
                    }
                }
                if (!(instanceRequirementsRequestAcceleratorTypesList = (SdkInternalList)instanceRequirements.getAcceleratorTypes()).isEmpty() || !instanceRequirementsRequestAcceleratorTypesList.isAutoConstruct()) {
                    int acceleratorTypesListIndex = 1;
                    for (String instanceRequirementsRequestAcceleratorTypesListValue : instanceRequirementsRequestAcceleratorTypesList) {
                        if (instanceRequirementsRequestAcceleratorTypesListValue != null) {
                            request.addParameter("LaunchTemplateData.InstanceRequirements.AcceleratorType." + acceleratorTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorTypesListValue));
                        }
                        ++acceleratorTypesListIndex;
                    }
                }
                if ((acceleratorCount = instanceRequirements.getAcceleratorCount()) != null) {
                    if (acceleratorCount.getMin() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.AcceleratorCount.Min", StringUtils.fromInteger((Integer)acceleratorCount.getMin()));
                    }
                    if (acceleratorCount.getMax() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.AcceleratorCount.Max", StringUtils.fromInteger((Integer)acceleratorCount.getMax()));
                    }
                }
                if (!(instanceRequirementsRequestAcceleratorManufacturersList = (SdkInternalList)instanceRequirements.getAcceleratorManufacturers()).isEmpty() || !instanceRequirementsRequestAcceleratorManufacturersList.isAutoConstruct()) {
                    int acceleratorManufacturersListIndex = 1;
                    for (String instanceRequirementsRequestAcceleratorManufacturersListValue : instanceRequirementsRequestAcceleratorManufacturersList) {
                        if (instanceRequirementsRequestAcceleratorManufacturersListValue != null) {
                            request.addParameter("LaunchTemplateData.InstanceRequirements.AcceleratorManufacturer." + acceleratorManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorManufacturersListValue));
                        }
                        ++acceleratorManufacturersListIndex;
                    }
                }
                if (!(instanceRequirementsRequestAcceleratorNamesList = (SdkInternalList)instanceRequirements.getAcceleratorNames()).isEmpty() || !instanceRequirementsRequestAcceleratorNamesList.isAutoConstruct()) {
                    int acceleratorNamesListIndex = 1;
                    for (String instanceRequirementsRequestAcceleratorNamesListValue : instanceRequirementsRequestAcceleratorNamesList) {
                        if (instanceRequirementsRequestAcceleratorNamesListValue != null) {
                            request.addParameter("LaunchTemplateData.InstanceRequirements.AcceleratorName." + acceleratorNamesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorNamesListValue));
                        }
                        ++acceleratorNamesListIndex;
                    }
                }
                if ((acceleratorTotalMemoryMiB = instanceRequirements.getAcceleratorTotalMemoryMiB()) != null) {
                    if (acceleratorTotalMemoryMiB.getMin() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.AcceleratorTotalMemoryMiB.Min", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMin()));
                    }
                    if (acceleratorTotalMemoryMiB.getMax() != null) {
                        request.addParameter("LaunchTemplateData.InstanceRequirements.AcceleratorTotalMemoryMiB.Max", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMax()));
                    }
                }
            }
            if ((privateDnsNameOptions = launchTemplateData.getPrivateDnsNameOptions()) != null) {
                if (privateDnsNameOptions.getHostnameType() != null) {
                    request.addParameter("LaunchTemplateData.PrivateDnsNameOptions.HostnameType", StringUtils.fromString((String)privateDnsNameOptions.getHostnameType()));
                }
                if (privateDnsNameOptions.getEnableResourceNameDnsARecord() != null) {
                    request.addParameter("LaunchTemplateData.PrivateDnsNameOptions.EnableResourceNameDnsARecord", StringUtils.fromBoolean((Boolean)privateDnsNameOptions.getEnableResourceNameDnsARecord()));
                }
                if (privateDnsNameOptions.getEnableResourceNameDnsAAAARecord() != null) {
                    request.addParameter("LaunchTemplateData.PrivateDnsNameOptions.EnableResourceNameDnsAAAARecord", StringUtils.fromBoolean((Boolean)privateDnsNameOptions.getEnableResourceNameDnsAAAARecord()));
                }
            }
        }
        return request;
    }
}

