/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVerifiedAccessEndpointEniOptions;
import com.amazonaws.services.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions;
import com.amazonaws.services.ec2.model.CreateVerifiedAccessEndpointRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateVerifiedAccessEndpointRequestMarshaller
implements Marshaller<Request<CreateVerifiedAccessEndpointRequest>, CreateVerifiedAccessEndpointRequest> {
    public Request<CreateVerifiedAccessEndpointRequest> marshall(CreateVerifiedAccessEndpointRequest createVerifiedAccessEndpointRequest) {
        SdkInternalList createVerifiedAccessEndpointRequestTagSpecificationsList;
        CreateVerifiedAccessEndpointEniOptions networkInterfaceOptions;
        CreateVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;
        SdkInternalList createVerifiedAccessEndpointRequestSecurityGroupIdsList;
        if (createVerifiedAccessEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVerifiedAccessEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVerifiedAccessEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVerifiedAccessEndpointRequest.getVerifiedAccessGroupId() != null) {
            request.addParameter("VerifiedAccessGroupId", StringUtils.fromString((String)createVerifiedAccessEndpointRequest.getVerifiedAccessGroupId()));
        }
        if (createVerifiedAccessEndpointRequest.getEndpointType() != null) {
            request.addParameter("EndpointType", StringUtils.fromString((String)createVerifiedAccessEndpointRequest.getEndpointType()));
        }
        if (createVerifiedAccessEndpointRequest.getAttachmentType() != null) {
            request.addParameter("AttachmentType", StringUtils.fromString((String)createVerifiedAccessEndpointRequest.getAttachmentType()));
        }
        if (createVerifiedAccessEndpointRequest.getDomainCertificateArn() != null) {
            request.addParameter("DomainCertificateArn", StringUtils.fromString((String)createVerifiedAccessEndpointRequest.getDomainCertificateArn()));
        }
        if (createVerifiedAccessEndpointRequest.getApplicationDomain() != null) {
            request.addParameter("ApplicationDomain", StringUtils.fromString((String)createVerifiedAccessEndpointRequest.getApplicationDomain()));
        }
        if (createVerifiedAccessEndpointRequest.getEndpointDomainPrefix() != null) {
            request.addParameter("EndpointDomainPrefix", StringUtils.fromString((String)createVerifiedAccessEndpointRequest.getEndpointDomainPrefix()));
        }
        if (!(createVerifiedAccessEndpointRequestSecurityGroupIdsList = (SdkInternalList)createVerifiedAccessEndpointRequest.getSecurityGroupIds()).isEmpty() || !createVerifiedAccessEndpointRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String createVerifiedAccessEndpointRequestSecurityGroupIdsListValue : createVerifiedAccessEndpointRequestSecurityGroupIdsList) {
                if (createVerifiedAccessEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)createVerifiedAccessEndpointRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if ((loadBalancerOptions = createVerifiedAccessEndpointRequest.getLoadBalancerOptions()) != null) {
            SdkInternalList createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList;
            if (loadBalancerOptions.getProtocol() != null) {
                request.addParameter("LoadBalancerOptions.Protocol", StringUtils.fromString((String)loadBalancerOptions.getProtocol()));
            }
            if (loadBalancerOptions.getPort() != null) {
                request.addParameter("LoadBalancerOptions.Port", StringUtils.fromInteger((Integer)loadBalancerOptions.getPort()));
            }
            if (loadBalancerOptions.getLoadBalancerArn() != null) {
                request.addParameter("LoadBalancerOptions.LoadBalancerArn", StringUtils.fromString((String)loadBalancerOptions.getLoadBalancerArn()));
            }
            if (!(createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList = (SdkInternalList)loadBalancerOptions.getSubnetIds()).isEmpty() || !createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList.isAutoConstruct()) {
                int subnetIdsListIndex = 1;
                for (String createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue : createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsList) {
                    if (createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue != null) {
                        request.addParameter("LoadBalancerOptions.SubnetId." + subnetIdsListIndex, StringUtils.fromString((String)createVerifiedAccessEndpointLoadBalancerOptionsSubnetIdsListValue));
                    }
                    ++subnetIdsListIndex;
                }
            }
        }
        if ((networkInterfaceOptions = createVerifiedAccessEndpointRequest.getNetworkInterfaceOptions()) != null) {
            if (networkInterfaceOptions.getNetworkInterfaceId() != null) {
                request.addParameter("NetworkInterfaceOptions.NetworkInterfaceId", StringUtils.fromString((String)networkInterfaceOptions.getNetworkInterfaceId()));
            }
            if (networkInterfaceOptions.getProtocol() != null) {
                request.addParameter("NetworkInterfaceOptions.Protocol", StringUtils.fromString((String)networkInterfaceOptions.getProtocol()));
            }
            if (networkInterfaceOptions.getPort() != null) {
                request.addParameter("NetworkInterfaceOptions.Port", StringUtils.fromInteger((Integer)networkInterfaceOptions.getPort()));
            }
        }
        if (createVerifiedAccessEndpointRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createVerifiedAccessEndpointRequest.getDescription()));
        }
        if (createVerifiedAccessEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)createVerifiedAccessEndpointRequest.getPolicyDocument()));
        }
        if (!(createVerifiedAccessEndpointRequestTagSpecificationsList = (SdkInternalList)createVerifiedAccessEndpointRequest.getTagSpecifications()).isEmpty() || !createVerifiedAccessEndpointRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVerifiedAccessEndpointRequestTagSpecificationsListValue : createVerifiedAccessEndpointRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVerifiedAccessEndpointRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createVerifiedAccessEndpointRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVerifiedAccessEndpointRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createVerifiedAccessEndpointRequest.getClientToken()));
        return request;
    }
}

