/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AcceptAddressTransferRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AcceptAddressTransferRequestMarshaller
implements Marshaller<Request<AcceptAddressTransferRequest>, AcceptAddressTransferRequest> {
    public Request<AcceptAddressTransferRequest> marshall(AcceptAddressTransferRequest acceptAddressTransferRequest) {
        SdkInternalList acceptAddressTransferRequestTagSpecificationsList;
        if (acceptAddressTransferRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)acceptAddressTransferRequest, "AmazonEC2");
        request.addParameter("Action", "AcceptAddressTransfer");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (acceptAddressTransferRequest.getAddress() != null) {
            request.addParameter("Address", StringUtils.fromString((String)acceptAddressTransferRequest.getAddress()));
        }
        if (!(acceptAddressTransferRequestTagSpecificationsList = (SdkInternalList)acceptAddressTransferRequest.getTagSpecifications()).isEmpty() || !acceptAddressTransferRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification acceptAddressTransferRequestTagSpecificationsListValue : acceptAddressTransferRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (acceptAddressTransferRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)acceptAddressTransferRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)acceptAddressTransferRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

