/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.NeuronDeviceInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class NeuronInfo
implements Serializable,
Cloneable {
    private SdkInternalList<NeuronDeviceInfo> neuronDevices;
    private Integer totalNeuronDeviceMemoryInMiB;

    public List<NeuronDeviceInfo> getNeuronDevices() {
        if (this.neuronDevices == null) {
            this.neuronDevices = new SdkInternalList();
        }
        return this.neuronDevices;
    }

    public void setNeuronDevices(Collection<NeuronDeviceInfo> neuronDevices) {
        if (neuronDevices == null) {
            this.neuronDevices = null;
            return;
        }
        this.neuronDevices = new SdkInternalList(neuronDevices);
    }

    public NeuronInfo withNeuronDevices(NeuronDeviceInfo ... neuronDevices) {
        if (this.neuronDevices == null) {
            this.setNeuronDevices((Collection<NeuronDeviceInfo>)new SdkInternalList(neuronDevices.length));
        }
        for (NeuronDeviceInfo ele : neuronDevices) {
            this.neuronDevices.add((Object)ele);
        }
        return this;
    }

    public NeuronInfo withNeuronDevices(Collection<NeuronDeviceInfo> neuronDevices) {
        this.setNeuronDevices(neuronDevices);
        return this;
    }

    public void setTotalNeuronDeviceMemoryInMiB(Integer totalNeuronDeviceMemoryInMiB) {
        this.totalNeuronDeviceMemoryInMiB = totalNeuronDeviceMemoryInMiB;
    }

    public Integer getTotalNeuronDeviceMemoryInMiB() {
        return this.totalNeuronDeviceMemoryInMiB;
    }

    public NeuronInfo withTotalNeuronDeviceMemoryInMiB(Integer totalNeuronDeviceMemoryInMiB) {
        this.setTotalNeuronDeviceMemoryInMiB(totalNeuronDeviceMemoryInMiB);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNeuronDevices() != null) {
            sb.append("NeuronDevices: ").append(this.getNeuronDevices()).append(",");
        }
        if (this.getTotalNeuronDeviceMemoryInMiB() != null) {
            sb.append("TotalNeuronDeviceMemoryInMiB: ").append(this.getTotalNeuronDeviceMemoryInMiB());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeuronInfo)) {
            return false;
        }
        NeuronInfo other = (NeuronInfo)obj;
        if (other.getNeuronDevices() == null ^ this.getNeuronDevices() == null) {
            return false;
        }
        if (other.getNeuronDevices() != null && !other.getNeuronDevices().equals(this.getNeuronDevices())) {
            return false;
        }
        if (other.getTotalNeuronDeviceMemoryInMiB() == null ^ this.getTotalNeuronDeviceMemoryInMiB() == null) {
            return false;
        }
        return other.getTotalNeuronDeviceMemoryInMiB() == null || other.getTotalNeuronDeviceMemoryInMiB().equals(this.getTotalNeuronDeviceMemoryInMiB());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNeuronDevices() == null ? 0 : this.getNeuronDevices().hashCode());
        hashCode = 31 * hashCode + (this.getTotalNeuronDeviceMemoryInMiB() == null ? 0 : this.getTotalNeuronDeviceMemoryInMiB().hashCode());
        return hashCode;
    }

    public NeuronInfo clone() {
        try {
            return (NeuronInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

