/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.UploadLayerPartRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UploadLayerPartRequestMarshaller
implements Marshaller<Request<UploadLayerPartRequest>, UploadLayerPartRequest> {
    public Request<UploadLayerPartRequest> marshall(UploadLayerPartRequest uploadLayerPartRequest) {
        if (uploadLayerPartRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)uploadLayerPartRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.UploadLayerPart");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (uploadLayerPartRequest.getRegistryId() != null) {
                jsonWriter.key("registryId").value((Object)uploadLayerPartRequest.getRegistryId());
            }
            if (uploadLayerPartRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value((Object)uploadLayerPartRequest.getRepositoryName());
            }
            if (uploadLayerPartRequest.getUploadId() != null) {
                jsonWriter.key("uploadId").value((Object)uploadLayerPartRequest.getUploadId());
            }
            if (uploadLayerPartRequest.getPartFirstByte() != null) {
                jsonWriter.key("partFirstByte").value((Object)uploadLayerPartRequest.getPartFirstByte());
            }
            if (uploadLayerPartRequest.getPartLastByte() != null) {
                jsonWriter.key("partLastByte").value((Object)uploadLayerPartRequest.getPartLastByte());
            }
            if (uploadLayerPartRequest.getLayerPartBlob() != null) {
                jsonWriter.key("layerPartBlob").value(uploadLayerPartRequest.getLayerPartBlob());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

