/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ClusterSetting;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateClusterSettingsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<ClusterSetting> settings;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public UpdateClusterSettingsRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<ClusterSetting> getSettings() {
        if (this.settings == null) {
            this.settings = new SdkInternalList();
        }
        return this.settings;
    }

    public void setSettings(Collection<ClusterSetting> settings) {
        if (settings == null) {
            this.settings = null;
            return;
        }
        this.settings = new SdkInternalList(settings);
    }

    public UpdateClusterSettingsRequest withSettings(ClusterSetting ... settings) {
        if (this.settings == null) {
            this.setSettings((Collection<ClusterSetting>)new SdkInternalList(settings.length));
        }
        for (ClusterSetting ele : settings) {
            this.settings.add((Object)ele);
        }
        return this;
    }

    public UpdateClusterSettingsRequest withSettings(Collection<ClusterSetting> settings) {
        this.setSettings(settings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterSettingsRequest)) {
            return false;
        }
        UpdateClusterSettingsRequest other = (UpdateClusterSettingsRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        return other.getSettings() == null || other.getSettings().equals(this.getSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        return hashCode;
    }

    public UpdateClusterSettingsRequest clone() {
        return (UpdateClusterSettingsRequest)super.clone();
    }
}

