/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.ManagedAgent;
import java.util.Date;

@SdkInternalApi
public class ManagedAgentMarshaller {
    private static final MarshallingInfo<Date> LASTSTARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStartedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reason").build();
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").build();
    private static final ManagedAgentMarshaller instance = new ManagedAgentMarshaller();

    public static ManagedAgentMarshaller getInstance() {
        return instance;
    }

    public void marshall(ManagedAgent managedAgent, ProtocolMarshaller protocolMarshaller) {
        if (managedAgent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)managedAgent.getLastStartedAt(), LASTSTARTEDAT_BINDING);
            protocolMarshaller.marshall((Object)managedAgent.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)managedAgent.getReason(), REASON_BINDING);
            protocolMarshaller.marshall((Object)managedAgent.getLastStatus(), LASTSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

