/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.LoadBalancer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateServiceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String serviceName;
    private String taskDefinition;
    private ListWithAutoConstructFlag<LoadBalancer> loadBalancers;
    private Integer desiredCount;
    private String clientToken;
    private String role;

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public CreateServiceRequest withCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public CreateServiceRequest withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public CreateServiceRequest withTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
        return this;
    }

    public List<LoadBalancer> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ListWithAutoConstructFlag();
            this.loadBalancers.setAutoConstruct(true);
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        ListWithAutoConstructFlag loadBalancersCopy = new ListWithAutoConstructFlag(loadBalancers.size());
        loadBalancersCopy.addAll(loadBalancers);
        this.loadBalancers = loadBalancersCopy;
    }

    public CreateServiceRequest withLoadBalancers(LoadBalancer ... loadBalancers) {
        if (this.getLoadBalancers() == null) {
            this.setLoadBalancers(new ArrayList<LoadBalancer>(loadBalancers.length));
        }
        for (LoadBalancer value : loadBalancers) {
            this.getLoadBalancers().add(value);
        }
        return this;
    }

    public CreateServiceRequest withLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
        } else {
            ListWithAutoConstructFlag loadBalancersCopy = new ListWithAutoConstructFlag(loadBalancers.size());
            loadBalancersCopy.addAll(loadBalancers);
            this.loadBalancers = loadBalancersCopy;
        }
        return this;
    }

    public Integer getDesiredCount() {
        return this.desiredCount;
    }

    public void setDesiredCount(Integer desiredCount) {
        this.desiredCount = desiredCount;
    }

    public CreateServiceRequest withDesiredCount(Integer desiredCount) {
        this.desiredCount = desiredCount;
        return this;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public CreateServiceRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public CreateServiceRequest withRole(String role) {
        this.role = role;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: " + this.getCluster() + ",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: " + this.getServiceName() + ",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: " + this.getTaskDefinition() + ",");
        }
        if (this.getLoadBalancers() != null) {
            sb.append("LoadBalancers: " + this.getLoadBalancers() + ",");
        }
        if (this.getDesiredCount() != null) {
            sb.append("DesiredCount: " + this.getDesiredCount() + ",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken() + ",");
        }
        if (this.getRole() != null) {
            sb.append("Role: " + this.getRole());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : this.getLoadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredCount() == null ? 0 : this.getDesiredCount().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !other.getLoadBalancers().equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getDesiredCount() == null ^ this.getDesiredCount() == null) {
            return false;
        }
        if (other.getDesiredCount() != null && !other.getDesiredCount().equals(this.getDesiredCount())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        return other.getRole() == null || other.getRole().equals(this.getRole());
    }

    public CreateServiceRequest clone() {
        return (CreateServiceRequest)super.clone();
    }
}

