/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.eks.AmazonEKS;
import com.amazonaws.services.eks.model.DescribeClusterRequest;
import com.amazonaws.services.eks.waiters.ClusterActive;
import com.amazonaws.services.eks.waiters.ClusterDeleted;
import com.amazonaws.services.eks.waiters.DescribeClusterFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonEKSWaiters {
    private final AmazonEKS client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonEKSWaiters");

    @SdkInternalApi
    public AmazonEKSWaiters(AmazonEKS client) {
        this.client = client;
    }

    public Waiter<DescribeClusterRequest> clusterDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClusterFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterDeleted.IsACTIVEMatcher(), new ClusterDeleted.IsCREATINGMatcher(), new ClusterDeleted.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClusterRequest> clusterActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClusterFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterActive.IsDELETINGMatcher(), new ClusterActive.IsFAILEDMatcher(), new ClusterActive.IsACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

