/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.FargateProfileSelector;
import com.amazonaws.services.eks.model.FargateProfileStatus;
import com.amazonaws.services.eks.model.transform.FargateProfileMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FargateProfile
implements Serializable,
Cloneable,
StructuredPojo {
    private String fargateProfileName;
    private String fargateProfileArn;
    private String clusterName;
    private Date createdAt;
    private String podExecutionRoleArn;
    private List<String> subnets;
    private List<FargateProfileSelector> selectors;
    private String status;
    private Map<String, String> tags;

    public void setFargateProfileName(String fargateProfileName) {
        this.fargateProfileName = fargateProfileName;
    }

    public String getFargateProfileName() {
        return this.fargateProfileName;
    }

    public FargateProfile withFargateProfileName(String fargateProfileName) {
        this.setFargateProfileName(fargateProfileName);
        return this;
    }

    public void setFargateProfileArn(String fargateProfileArn) {
        this.fargateProfileArn = fargateProfileArn;
    }

    public String getFargateProfileArn() {
        return this.fargateProfileArn;
    }

    public FargateProfile withFargateProfileArn(String fargateProfileArn) {
        this.setFargateProfileArn(fargateProfileArn);
        return this;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public FargateProfile withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public FargateProfile withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setPodExecutionRoleArn(String podExecutionRoleArn) {
        this.podExecutionRoleArn = podExecutionRoleArn;
    }

    public String getPodExecutionRoleArn() {
        return this.podExecutionRoleArn;
    }

    public FargateProfile withPodExecutionRoleArn(String podExecutionRoleArn) {
        this.setPodExecutionRoleArn(podExecutionRoleArn);
        return this;
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new ArrayList<String>(subnets);
    }

    public FargateProfile withSubnets(String ... subnets) {
        if (this.subnets == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    public FargateProfile withSubnets(Collection<String> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public List<FargateProfileSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(Collection<FargateProfileSelector> selectors) {
        if (selectors == null) {
            this.selectors = null;
            return;
        }
        this.selectors = new ArrayList<FargateProfileSelector>(selectors);
    }

    public FargateProfile withSelectors(FargateProfileSelector ... selectors) {
        if (this.selectors == null) {
            this.setSelectors(new ArrayList<FargateProfileSelector>(selectors.length));
        }
        for (FargateProfileSelector ele : selectors) {
            this.selectors.add(ele);
        }
        return this;
    }

    public FargateProfile withSelectors(Collection<FargateProfileSelector> selectors) {
        this.setSelectors(selectors);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public FargateProfile withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public FargateProfile withStatus(FargateProfileStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public FargateProfile withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public FargateProfile addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public FargateProfile clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFargateProfileName() != null) {
            sb.append("FargateProfileName: ").append(this.getFargateProfileName()).append(",");
        }
        if (this.getFargateProfileArn() != null) {
            sb.append("FargateProfileArn: ").append(this.getFargateProfileArn()).append(",");
        }
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getPodExecutionRoleArn() != null) {
            sb.append("PodExecutionRoleArn: ").append(this.getPodExecutionRoleArn()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets()).append(",");
        }
        if (this.getSelectors() != null) {
            sb.append("Selectors: ").append(this.getSelectors()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FargateProfile)) {
            return false;
        }
        FargateProfile other = (FargateProfile)obj;
        if (other.getFargateProfileName() == null ^ this.getFargateProfileName() == null) {
            return false;
        }
        if (other.getFargateProfileName() != null && !other.getFargateProfileName().equals(this.getFargateProfileName())) {
            return false;
        }
        if (other.getFargateProfileArn() == null ^ this.getFargateProfileArn() == null) {
            return false;
        }
        if (other.getFargateProfileArn() != null && !other.getFargateProfileArn().equals(this.getFargateProfileArn())) {
            return false;
        }
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getPodExecutionRoleArn() == null ^ this.getPodExecutionRoleArn() == null) {
            return false;
        }
        if (other.getPodExecutionRoleArn() != null && !other.getPodExecutionRoleArn().equals(this.getPodExecutionRoleArn())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !other.getSubnets().equals(this.getSubnets())) {
            return false;
        }
        if (other.getSelectors() == null ^ this.getSelectors() == null) {
            return false;
        }
        if (other.getSelectors() != null && !other.getSelectors().equals(this.getSelectors())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFargateProfileName() == null ? 0 : this.getFargateProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getFargateProfileArn() == null ? 0 : this.getFargateProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getPodExecutionRoleArn() == null ? 0 : this.getPodExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getSelectors() == null ? 0 : this.getSelectors().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public FargateProfile clone() {
        try {
            return (FargateProfile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FargateProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

