/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.eks.AmazonEKSAsync;
import com.amazonaws.services.eks.AmazonEKSAsyncClientBuilder;
import com.amazonaws.services.eks.AmazonEKSClient;
import com.amazonaws.services.eks.model.AssociateEncryptionConfigRequest;
import com.amazonaws.services.eks.model.AssociateEncryptionConfigResult;
import com.amazonaws.services.eks.model.AssociateIdentityProviderConfigRequest;
import com.amazonaws.services.eks.model.AssociateIdentityProviderConfigResult;
import com.amazonaws.services.eks.model.CreateAddonRequest;
import com.amazonaws.services.eks.model.CreateAddonResult;
import com.amazonaws.services.eks.model.CreateClusterRequest;
import com.amazonaws.services.eks.model.CreateClusterResult;
import com.amazonaws.services.eks.model.CreateFargateProfileRequest;
import com.amazonaws.services.eks.model.CreateFargateProfileResult;
import com.amazonaws.services.eks.model.CreateNodegroupRequest;
import com.amazonaws.services.eks.model.CreateNodegroupResult;
import com.amazonaws.services.eks.model.DeleteAddonRequest;
import com.amazonaws.services.eks.model.DeleteAddonResult;
import com.amazonaws.services.eks.model.DeleteClusterRequest;
import com.amazonaws.services.eks.model.DeleteClusterResult;
import com.amazonaws.services.eks.model.DeleteFargateProfileRequest;
import com.amazonaws.services.eks.model.DeleteFargateProfileResult;
import com.amazonaws.services.eks.model.DeleteNodegroupRequest;
import com.amazonaws.services.eks.model.DeleteNodegroupResult;
import com.amazonaws.services.eks.model.DescribeAddonRequest;
import com.amazonaws.services.eks.model.DescribeAddonResult;
import com.amazonaws.services.eks.model.DescribeAddonVersionsRequest;
import com.amazonaws.services.eks.model.DescribeAddonVersionsResult;
import com.amazonaws.services.eks.model.DescribeClusterRequest;
import com.amazonaws.services.eks.model.DescribeClusterResult;
import com.amazonaws.services.eks.model.DescribeFargateProfileRequest;
import com.amazonaws.services.eks.model.DescribeFargateProfileResult;
import com.amazonaws.services.eks.model.DescribeIdentityProviderConfigRequest;
import com.amazonaws.services.eks.model.DescribeIdentityProviderConfigResult;
import com.amazonaws.services.eks.model.DescribeNodegroupRequest;
import com.amazonaws.services.eks.model.DescribeNodegroupResult;
import com.amazonaws.services.eks.model.DescribeUpdateRequest;
import com.amazonaws.services.eks.model.DescribeUpdateResult;
import com.amazonaws.services.eks.model.DisassociateIdentityProviderConfigRequest;
import com.amazonaws.services.eks.model.DisassociateIdentityProviderConfigResult;
import com.amazonaws.services.eks.model.ListAddonsRequest;
import com.amazonaws.services.eks.model.ListAddonsResult;
import com.amazonaws.services.eks.model.ListClustersRequest;
import com.amazonaws.services.eks.model.ListClustersResult;
import com.amazonaws.services.eks.model.ListFargateProfilesRequest;
import com.amazonaws.services.eks.model.ListFargateProfilesResult;
import com.amazonaws.services.eks.model.ListIdentityProviderConfigsRequest;
import com.amazonaws.services.eks.model.ListIdentityProviderConfigsResult;
import com.amazonaws.services.eks.model.ListNodegroupsRequest;
import com.amazonaws.services.eks.model.ListNodegroupsResult;
import com.amazonaws.services.eks.model.ListTagsForResourceRequest;
import com.amazonaws.services.eks.model.ListTagsForResourceResult;
import com.amazonaws.services.eks.model.ListUpdatesRequest;
import com.amazonaws.services.eks.model.ListUpdatesResult;
import com.amazonaws.services.eks.model.TagResourceRequest;
import com.amazonaws.services.eks.model.TagResourceResult;
import com.amazonaws.services.eks.model.UntagResourceRequest;
import com.amazonaws.services.eks.model.UntagResourceResult;
import com.amazonaws.services.eks.model.UpdateAddonRequest;
import com.amazonaws.services.eks.model.UpdateAddonResult;
import com.amazonaws.services.eks.model.UpdateClusterConfigRequest;
import com.amazonaws.services.eks.model.UpdateClusterConfigResult;
import com.amazonaws.services.eks.model.UpdateClusterVersionRequest;
import com.amazonaws.services.eks.model.UpdateClusterVersionResult;
import com.amazonaws.services.eks.model.UpdateNodegroupConfigRequest;
import com.amazonaws.services.eks.model.UpdateNodegroupConfigResult;
import com.amazonaws.services.eks.model.UpdateNodegroupVersionRequest;
import com.amazonaws.services.eks.model.UpdateNodegroupVersionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonEKSAsyncClient
extends AmazonEKSClient
implements AmazonEKSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonEKSAsyncClientBuilder asyncBuilder() {
        return AmazonEKSAsyncClientBuilder.standard();
    }

    AmazonEKSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonEKSAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateEncryptionConfigResult> associateEncryptionConfigAsync(AssociateEncryptionConfigRequest request) {
        return this.associateEncryptionConfigAsync(request, null);
    }

    @Override
    public Future<AssociateEncryptionConfigResult> associateEncryptionConfigAsync(AssociateEncryptionConfigRequest request, final AsyncHandler<AssociateEncryptionConfigRequest, AssociateEncryptionConfigResult> asyncHandler) {
        final AssociateEncryptionConfigRequest finalRequest = (AssociateEncryptionConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateEncryptionConfigResult>(){

            @Override
            public AssociateEncryptionConfigResult call() throws Exception {
                AssociateEncryptionConfigResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeAssociateEncryptionConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateIdentityProviderConfigResult> associateIdentityProviderConfigAsync(AssociateIdentityProviderConfigRequest request) {
        return this.associateIdentityProviderConfigAsync(request, null);
    }

    @Override
    public Future<AssociateIdentityProviderConfigResult> associateIdentityProviderConfigAsync(AssociateIdentityProviderConfigRequest request, final AsyncHandler<AssociateIdentityProviderConfigRequest, AssociateIdentityProviderConfigResult> asyncHandler) {
        final AssociateIdentityProviderConfigRequest finalRequest = (AssociateIdentityProviderConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateIdentityProviderConfigResult>(){

            @Override
            public AssociateIdentityProviderConfigResult call() throws Exception {
                AssociateIdentityProviderConfigResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeAssociateIdentityProviderConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAddonResult> createAddonAsync(CreateAddonRequest request) {
        return this.createAddonAsync(request, null);
    }

    @Override
    public Future<CreateAddonResult> createAddonAsync(CreateAddonRequest request, final AsyncHandler<CreateAddonRequest, CreateAddonResult> asyncHandler) {
        final CreateAddonRequest finalRequest = (CreateAddonRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAddonResult>(){

            @Override
            public CreateAddonResult call() throws Exception {
                CreateAddonResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeCreateAddon(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFargateProfileResult> createFargateProfileAsync(CreateFargateProfileRequest request) {
        return this.createFargateProfileAsync(request, null);
    }

    @Override
    public Future<CreateFargateProfileResult> createFargateProfileAsync(CreateFargateProfileRequest request, final AsyncHandler<CreateFargateProfileRequest, CreateFargateProfileResult> asyncHandler) {
        final CreateFargateProfileRequest finalRequest = (CreateFargateProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFargateProfileResult>(){

            @Override
            public CreateFargateProfileResult call() throws Exception {
                CreateFargateProfileResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeCreateFargateProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateNodegroupResult> createNodegroupAsync(CreateNodegroupRequest request) {
        return this.createNodegroupAsync(request, null);
    }

    @Override
    public Future<CreateNodegroupResult> createNodegroupAsync(CreateNodegroupRequest request, final AsyncHandler<CreateNodegroupRequest, CreateNodegroupResult> asyncHandler) {
        final CreateNodegroupRequest finalRequest = (CreateNodegroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateNodegroupResult>(){

            @Override
            public CreateNodegroupResult call() throws Exception {
                CreateNodegroupResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeCreateNodegroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAddonResult> deleteAddonAsync(DeleteAddonRequest request) {
        return this.deleteAddonAsync(request, null);
    }

    @Override
    public Future<DeleteAddonResult> deleteAddonAsync(DeleteAddonRequest request, final AsyncHandler<DeleteAddonRequest, DeleteAddonResult> asyncHandler) {
        final DeleteAddonRequest finalRequest = (DeleteAddonRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAddonResult>(){

            @Override
            public DeleteAddonResult call() throws Exception {
                DeleteAddonResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDeleteAddon(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        final DeleteClusterRequest finalRequest = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDeleteCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFargateProfileResult> deleteFargateProfileAsync(DeleteFargateProfileRequest request) {
        return this.deleteFargateProfileAsync(request, null);
    }

    @Override
    public Future<DeleteFargateProfileResult> deleteFargateProfileAsync(DeleteFargateProfileRequest request, final AsyncHandler<DeleteFargateProfileRequest, DeleteFargateProfileResult> asyncHandler) {
        final DeleteFargateProfileRequest finalRequest = (DeleteFargateProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFargateProfileResult>(){

            @Override
            public DeleteFargateProfileResult call() throws Exception {
                DeleteFargateProfileResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDeleteFargateProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNodegroupResult> deleteNodegroupAsync(DeleteNodegroupRequest request) {
        return this.deleteNodegroupAsync(request, null);
    }

    @Override
    public Future<DeleteNodegroupResult> deleteNodegroupAsync(DeleteNodegroupRequest request, final AsyncHandler<DeleteNodegroupRequest, DeleteNodegroupResult> asyncHandler) {
        final DeleteNodegroupRequest finalRequest = (DeleteNodegroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNodegroupResult>(){

            @Override
            public DeleteNodegroupResult call() throws Exception {
                DeleteNodegroupResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDeleteNodegroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAddonResult> describeAddonAsync(DescribeAddonRequest request) {
        return this.describeAddonAsync(request, null);
    }

    @Override
    public Future<DescribeAddonResult> describeAddonAsync(DescribeAddonRequest request, final AsyncHandler<DescribeAddonRequest, DescribeAddonResult> asyncHandler) {
        final DescribeAddonRequest finalRequest = (DescribeAddonRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAddonResult>(){

            @Override
            public DescribeAddonResult call() throws Exception {
                DescribeAddonResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDescribeAddon(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAddonVersionsResult> describeAddonVersionsAsync(DescribeAddonVersionsRequest request) {
        return this.describeAddonVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeAddonVersionsResult> describeAddonVersionsAsync(DescribeAddonVersionsRequest request, final AsyncHandler<DescribeAddonVersionsRequest, DescribeAddonVersionsResult> asyncHandler) {
        final DescribeAddonVersionsRequest finalRequest = (DescribeAddonVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAddonVersionsResult>(){

            @Override
            public DescribeAddonVersionsResult call() throws Exception {
                DescribeAddonVersionsResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDescribeAddonVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request) {
        return this.describeClusterAsync(request, null);
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request, final AsyncHandler<DescribeClusterRequest, DescribeClusterResult> asyncHandler) {
        final DescribeClusterRequest finalRequest = (DescribeClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClusterResult>(){

            @Override
            public DescribeClusterResult call() throws Exception {
                DescribeClusterResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDescribeCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFargateProfileResult> describeFargateProfileAsync(DescribeFargateProfileRequest request) {
        return this.describeFargateProfileAsync(request, null);
    }

    @Override
    public Future<DescribeFargateProfileResult> describeFargateProfileAsync(DescribeFargateProfileRequest request, final AsyncHandler<DescribeFargateProfileRequest, DescribeFargateProfileResult> asyncHandler) {
        final DescribeFargateProfileRequest finalRequest = (DescribeFargateProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFargateProfileResult>(){

            @Override
            public DescribeFargateProfileResult call() throws Exception {
                DescribeFargateProfileResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDescribeFargateProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityProviderConfigResult> describeIdentityProviderConfigAsync(DescribeIdentityProviderConfigRequest request) {
        return this.describeIdentityProviderConfigAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityProviderConfigResult> describeIdentityProviderConfigAsync(DescribeIdentityProviderConfigRequest request, final AsyncHandler<DescribeIdentityProviderConfigRequest, DescribeIdentityProviderConfigResult> asyncHandler) {
        final DescribeIdentityProviderConfigRequest finalRequest = (DescribeIdentityProviderConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeIdentityProviderConfigResult>(){

            @Override
            public DescribeIdentityProviderConfigResult call() throws Exception {
                DescribeIdentityProviderConfigResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDescribeIdentityProviderConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNodegroupResult> describeNodegroupAsync(DescribeNodegroupRequest request) {
        return this.describeNodegroupAsync(request, null);
    }

    @Override
    public Future<DescribeNodegroupResult> describeNodegroupAsync(DescribeNodegroupRequest request, final AsyncHandler<DescribeNodegroupRequest, DescribeNodegroupResult> asyncHandler) {
        final DescribeNodegroupRequest finalRequest = (DescribeNodegroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeNodegroupResult>(){

            @Override
            public DescribeNodegroupResult call() throws Exception {
                DescribeNodegroupResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDescribeNodegroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUpdateResult> describeUpdateAsync(DescribeUpdateRequest request) {
        return this.describeUpdateAsync(request, null);
    }

    @Override
    public Future<DescribeUpdateResult> describeUpdateAsync(DescribeUpdateRequest request, final AsyncHandler<DescribeUpdateRequest, DescribeUpdateResult> asyncHandler) {
        final DescribeUpdateRequest finalRequest = (DescribeUpdateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUpdateResult>(){

            @Override
            public DescribeUpdateResult call() throws Exception {
                DescribeUpdateResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDescribeUpdate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateIdentityProviderConfigResult> disassociateIdentityProviderConfigAsync(DisassociateIdentityProviderConfigRequest request) {
        return this.disassociateIdentityProviderConfigAsync(request, null);
    }

    @Override
    public Future<DisassociateIdentityProviderConfigResult> disassociateIdentityProviderConfigAsync(DisassociateIdentityProviderConfigRequest request, final AsyncHandler<DisassociateIdentityProviderConfigRequest, DisassociateIdentityProviderConfigResult> asyncHandler) {
        final DisassociateIdentityProviderConfigRequest finalRequest = (DisassociateIdentityProviderConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateIdentityProviderConfigResult>(){

            @Override
            public DisassociateIdentityProviderConfigResult call() throws Exception {
                DisassociateIdentityProviderConfigResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDisassociateIdentityProviderConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAddonsResult> listAddonsAsync(ListAddonsRequest request) {
        return this.listAddonsAsync(request, null);
    }

    @Override
    public Future<ListAddonsResult> listAddonsAsync(ListAddonsRequest request, final AsyncHandler<ListAddonsRequest, ListAddonsResult> asyncHandler) {
        final ListAddonsRequest finalRequest = (ListAddonsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAddonsResult>(){

            @Override
            public ListAddonsResult call() throws Exception {
                ListAddonsResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListAddons(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {
        return this.listClustersAsync(request, null);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        final ListClustersRequest finalRequest = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFargateProfilesResult> listFargateProfilesAsync(ListFargateProfilesRequest request) {
        return this.listFargateProfilesAsync(request, null);
    }

    @Override
    public Future<ListFargateProfilesResult> listFargateProfilesAsync(ListFargateProfilesRequest request, final AsyncHandler<ListFargateProfilesRequest, ListFargateProfilesResult> asyncHandler) {
        final ListFargateProfilesRequest finalRequest = (ListFargateProfilesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFargateProfilesResult>(){

            @Override
            public ListFargateProfilesResult call() throws Exception {
                ListFargateProfilesResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListFargateProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentityProviderConfigsResult> listIdentityProviderConfigsAsync(ListIdentityProviderConfigsRequest request) {
        return this.listIdentityProviderConfigsAsync(request, null);
    }

    @Override
    public Future<ListIdentityProviderConfigsResult> listIdentityProviderConfigsAsync(ListIdentityProviderConfigsRequest request, final AsyncHandler<ListIdentityProviderConfigsRequest, ListIdentityProviderConfigsResult> asyncHandler) {
        final ListIdentityProviderConfigsRequest finalRequest = (ListIdentityProviderConfigsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListIdentityProviderConfigsResult>(){

            @Override
            public ListIdentityProviderConfigsResult call() throws Exception {
                ListIdentityProviderConfigsResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListIdentityProviderConfigs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListNodegroupsResult> listNodegroupsAsync(ListNodegroupsRequest request) {
        return this.listNodegroupsAsync(request, null);
    }

    @Override
    public Future<ListNodegroupsResult> listNodegroupsAsync(ListNodegroupsRequest request, final AsyncHandler<ListNodegroupsRequest, ListNodegroupsResult> asyncHandler) {
        final ListNodegroupsRequest finalRequest = (ListNodegroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListNodegroupsResult>(){

            @Override
            public ListNodegroupsResult call() throws Exception {
                ListNodegroupsResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListNodegroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUpdatesResult> listUpdatesAsync(ListUpdatesRequest request) {
        return this.listUpdatesAsync(request, null);
    }

    @Override
    public Future<ListUpdatesResult> listUpdatesAsync(ListUpdatesRequest request, final AsyncHandler<ListUpdatesRequest, ListUpdatesResult> asyncHandler) {
        final ListUpdatesRequest finalRequest = (ListUpdatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUpdatesResult>(){

            @Override
            public ListUpdatesResult call() throws Exception {
                ListUpdatesResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListUpdates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAddonResult> updateAddonAsync(UpdateAddonRequest request) {
        return this.updateAddonAsync(request, null);
    }

    @Override
    public Future<UpdateAddonResult> updateAddonAsync(UpdateAddonRequest request, final AsyncHandler<UpdateAddonRequest, UpdateAddonResult> asyncHandler) {
        final UpdateAddonRequest finalRequest = (UpdateAddonRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAddonResult>(){

            @Override
            public UpdateAddonResult call() throws Exception {
                UpdateAddonResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeUpdateAddon(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterConfigResult> updateClusterConfigAsync(UpdateClusterConfigRequest request) {
        return this.updateClusterConfigAsync(request, null);
    }

    @Override
    public Future<UpdateClusterConfigResult> updateClusterConfigAsync(UpdateClusterConfigRequest request, final AsyncHandler<UpdateClusterConfigRequest, UpdateClusterConfigResult> asyncHandler) {
        final UpdateClusterConfigRequest finalRequest = (UpdateClusterConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterConfigResult>(){

            @Override
            public UpdateClusterConfigResult call() throws Exception {
                UpdateClusterConfigResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeUpdateClusterConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterVersionResult> updateClusterVersionAsync(UpdateClusterVersionRequest request) {
        return this.updateClusterVersionAsync(request, null);
    }

    @Override
    public Future<UpdateClusterVersionResult> updateClusterVersionAsync(UpdateClusterVersionRequest request, final AsyncHandler<UpdateClusterVersionRequest, UpdateClusterVersionResult> asyncHandler) {
        final UpdateClusterVersionRequest finalRequest = (UpdateClusterVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterVersionResult>(){

            @Override
            public UpdateClusterVersionResult call() throws Exception {
                UpdateClusterVersionResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeUpdateClusterVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNodegroupConfigResult> updateNodegroupConfigAsync(UpdateNodegroupConfigRequest request) {
        return this.updateNodegroupConfigAsync(request, null);
    }

    @Override
    public Future<UpdateNodegroupConfigResult> updateNodegroupConfigAsync(UpdateNodegroupConfigRequest request, final AsyncHandler<UpdateNodegroupConfigRequest, UpdateNodegroupConfigResult> asyncHandler) {
        final UpdateNodegroupConfigRequest finalRequest = (UpdateNodegroupConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNodegroupConfigResult>(){

            @Override
            public UpdateNodegroupConfigResult call() throws Exception {
                UpdateNodegroupConfigResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeUpdateNodegroupConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNodegroupVersionResult> updateNodegroupVersionAsync(UpdateNodegroupVersionRequest request) {
        return this.updateNodegroupVersionAsync(request, null);
    }

    @Override
    public Future<UpdateNodegroupVersionResult> updateNodegroupVersionAsync(UpdateNodegroupVersionRequest request, final AsyncHandler<UpdateNodegroupVersionRequest, UpdateNodegroupVersionResult> asyncHandler) {
        final UpdateNodegroupVersionRequest finalRequest = (UpdateNodegroupVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNodegroupVersionResult>(){

            @Override
            public UpdateNodegroupVersionResult call() throws Exception {
                UpdateNodegroupVersionResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeUpdateNodegroupVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

