/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.eks.model.AMITypes;
import com.amazonaws.services.eks.model.CapacityTypes;
import com.amazonaws.services.eks.model.LaunchTemplateSpecification;
import com.amazonaws.services.eks.model.NodegroupScalingConfig;
import com.amazonaws.services.eks.model.NodegroupUpdateConfig;
import com.amazonaws.services.eks.model.RemoteAccessConfig;
import com.amazonaws.services.eks.model.Taint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateNodegroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterName;
    private String nodegroupName;
    private NodegroupScalingConfig scalingConfig;
    private Integer diskSize;
    private List<String> subnets;
    private List<String> instanceTypes;
    private String amiType;
    private RemoteAccessConfig remoteAccess;
    private String nodeRole;
    private Map<String, String> labels;
    private List<Taint> taints;
    private Map<String, String> tags;
    private String clientRequestToken;
    private LaunchTemplateSpecification launchTemplate;
    private NodegroupUpdateConfig updateConfig;
    private String capacityType;
    private String version;
    private String releaseVersion;

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public CreateNodegroupRequest withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setNodegroupName(String nodegroupName) {
        this.nodegroupName = nodegroupName;
    }

    public String getNodegroupName() {
        return this.nodegroupName;
    }

    public CreateNodegroupRequest withNodegroupName(String nodegroupName) {
        this.setNodegroupName(nodegroupName);
        return this;
    }

    public void setScalingConfig(NodegroupScalingConfig scalingConfig) {
        this.scalingConfig = scalingConfig;
    }

    public NodegroupScalingConfig getScalingConfig() {
        return this.scalingConfig;
    }

    public CreateNodegroupRequest withScalingConfig(NodegroupScalingConfig scalingConfig) {
        this.setScalingConfig(scalingConfig);
        return this;
    }

    public void setDiskSize(Integer diskSize) {
        this.diskSize = diskSize;
    }

    public Integer getDiskSize() {
        return this.diskSize;
    }

    public CreateNodegroupRequest withDiskSize(Integer diskSize) {
        this.setDiskSize(diskSize);
        return this;
    }

    public List<String> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        this.subnets = new ArrayList<String>(subnets);
    }

    public CreateNodegroupRequest withSubnets(String ... subnets) {
        if (this.subnets == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String ele : subnets) {
            this.subnets.add(ele);
        }
        return this;
    }

    public CreateNodegroupRequest withSubnets(Collection<String> subnets) {
        this.setSubnets(subnets);
        return this;
    }

    public List<String> getInstanceTypes() {
        return this.instanceTypes;
    }

    public void setInstanceTypes(Collection<String> instanceTypes) {
        if (instanceTypes == null) {
            this.instanceTypes = null;
            return;
        }
        this.instanceTypes = new ArrayList<String>(instanceTypes);
    }

    public CreateNodegroupRequest withInstanceTypes(String ... instanceTypes) {
        if (this.instanceTypes == null) {
            this.setInstanceTypes(new ArrayList<String>(instanceTypes.length));
        }
        for (String ele : instanceTypes) {
            this.instanceTypes.add(ele);
        }
        return this;
    }

    public CreateNodegroupRequest withInstanceTypes(Collection<String> instanceTypes) {
        this.setInstanceTypes(instanceTypes);
        return this;
    }

    public void setAmiType(String amiType) {
        this.amiType = amiType;
    }

    public String getAmiType() {
        return this.amiType;
    }

    public CreateNodegroupRequest withAmiType(String amiType) {
        this.setAmiType(amiType);
        return this;
    }

    public CreateNodegroupRequest withAmiType(AMITypes amiType) {
        this.amiType = amiType.toString();
        return this;
    }

    public void setRemoteAccess(RemoteAccessConfig remoteAccess) {
        this.remoteAccess = remoteAccess;
    }

    public RemoteAccessConfig getRemoteAccess() {
        return this.remoteAccess;
    }

    public CreateNodegroupRequest withRemoteAccess(RemoteAccessConfig remoteAccess) {
        this.setRemoteAccess(remoteAccess);
        return this;
    }

    public void setNodeRole(String nodeRole) {
        this.nodeRole = nodeRole;
    }

    public String getNodeRole() {
        return this.nodeRole;
    }

    public CreateNodegroupRequest withNodeRole(String nodeRole) {
        this.setNodeRole(nodeRole);
        return this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public CreateNodegroupRequest withLabels(Map<String, String> labels) {
        this.setLabels(labels);
        return this;
    }

    public CreateNodegroupRequest addLabelsEntry(String key, String value) {
        if (null == this.labels) {
            this.labels = new HashMap<String, String>();
        }
        if (this.labels.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.labels.put(key, value);
        return this;
    }

    public CreateNodegroupRequest clearLabelsEntries() {
        this.labels = null;
        return this;
    }

    public List<Taint> getTaints() {
        return this.taints;
    }

    public void setTaints(Collection<Taint> taints) {
        if (taints == null) {
            this.taints = null;
            return;
        }
        this.taints = new ArrayList<Taint>(taints);
    }

    public CreateNodegroupRequest withTaints(Taint ... taints) {
        if (this.taints == null) {
            this.setTaints(new ArrayList<Taint>(taints.length));
        }
        for (Taint ele : taints) {
            this.taints.add(ele);
        }
        return this;
    }

    public CreateNodegroupRequest withTaints(Collection<Taint> taints) {
        this.setTaints(taints);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateNodegroupRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateNodegroupRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateNodegroupRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateNodegroupRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setLaunchTemplate(LaunchTemplateSpecification launchTemplate) {
        this.launchTemplate = launchTemplate;
    }

    public LaunchTemplateSpecification getLaunchTemplate() {
        return this.launchTemplate;
    }

    public CreateNodegroupRequest withLaunchTemplate(LaunchTemplateSpecification launchTemplate) {
        this.setLaunchTemplate(launchTemplate);
        return this;
    }

    public void setUpdateConfig(NodegroupUpdateConfig updateConfig) {
        this.updateConfig = updateConfig;
    }

    public NodegroupUpdateConfig getUpdateConfig() {
        return this.updateConfig;
    }

    public CreateNodegroupRequest withUpdateConfig(NodegroupUpdateConfig updateConfig) {
        this.setUpdateConfig(updateConfig);
        return this;
    }

    public void setCapacityType(String capacityType) {
        this.capacityType = capacityType;
    }

    public String getCapacityType() {
        return this.capacityType;
    }

    public CreateNodegroupRequest withCapacityType(String capacityType) {
        this.setCapacityType(capacityType);
        return this;
    }

    public CreateNodegroupRequest withCapacityType(CapacityTypes capacityType) {
        this.capacityType = capacityType.toString();
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public CreateNodegroupRequest withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setReleaseVersion(String releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public CreateNodegroupRequest withReleaseVersion(String releaseVersion) {
        this.setReleaseVersion(releaseVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getNodegroupName() != null) {
            sb.append("NodegroupName: ").append(this.getNodegroupName()).append(",");
        }
        if (this.getScalingConfig() != null) {
            sb.append("ScalingConfig: ").append(this.getScalingConfig()).append(",");
        }
        if (this.getDiskSize() != null) {
            sb.append("DiskSize: ").append(this.getDiskSize()).append(",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: ").append(this.getSubnets()).append(",");
        }
        if (this.getInstanceTypes() != null) {
            sb.append("InstanceTypes: ").append(this.getInstanceTypes()).append(",");
        }
        if (this.getAmiType() != null) {
            sb.append("AmiType: ").append(this.getAmiType()).append(",");
        }
        if (this.getRemoteAccess() != null) {
            sb.append("RemoteAccess: ").append(this.getRemoteAccess()).append(",");
        }
        if (this.getNodeRole() != null) {
            sb.append("NodeRole: ").append(this.getNodeRole()).append(",");
        }
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels()).append(",");
        }
        if (this.getTaints() != null) {
            sb.append("Taints: ").append(this.getTaints()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getLaunchTemplate() != null) {
            sb.append("LaunchTemplate: ").append(this.getLaunchTemplate()).append(",");
        }
        if (this.getUpdateConfig() != null) {
            sb.append("UpdateConfig: ").append(this.getUpdateConfig()).append(",");
        }
        if (this.getCapacityType() != null) {
            sb.append("CapacityType: ").append(this.getCapacityType()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getReleaseVersion() != null) {
            sb.append("ReleaseVersion: ").append(this.getReleaseVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodegroupRequest)) {
            return false;
        }
        CreateNodegroupRequest other = (CreateNodegroupRequest)obj;
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getNodegroupName() == null ^ this.getNodegroupName() == null) {
            return false;
        }
        if (other.getNodegroupName() != null && !other.getNodegroupName().equals(this.getNodegroupName())) {
            return false;
        }
        if (other.getScalingConfig() == null ^ this.getScalingConfig() == null) {
            return false;
        }
        if (other.getScalingConfig() != null && !other.getScalingConfig().equals(this.getScalingConfig())) {
            return false;
        }
        if (other.getDiskSize() == null ^ this.getDiskSize() == null) {
            return false;
        }
        if (other.getDiskSize() != null && !other.getDiskSize().equals(this.getDiskSize())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !other.getSubnets().equals(this.getSubnets())) {
            return false;
        }
        if (other.getInstanceTypes() == null ^ this.getInstanceTypes() == null) {
            return false;
        }
        if (other.getInstanceTypes() != null && !other.getInstanceTypes().equals(this.getInstanceTypes())) {
            return false;
        }
        if (other.getAmiType() == null ^ this.getAmiType() == null) {
            return false;
        }
        if (other.getAmiType() != null && !other.getAmiType().equals(this.getAmiType())) {
            return false;
        }
        if (other.getRemoteAccess() == null ^ this.getRemoteAccess() == null) {
            return false;
        }
        if (other.getRemoteAccess() != null && !other.getRemoteAccess().equals(this.getRemoteAccess())) {
            return false;
        }
        if (other.getNodeRole() == null ^ this.getNodeRole() == null) {
            return false;
        }
        if (other.getNodeRole() != null && !other.getNodeRole().equals(this.getNodeRole())) {
            return false;
        }
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        if (other.getLabels() != null && !other.getLabels().equals(this.getLabels())) {
            return false;
        }
        if (other.getTaints() == null ^ this.getTaints() == null) {
            return false;
        }
        if (other.getTaints() != null && !other.getTaints().equals(this.getTaints())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getLaunchTemplate() == null ^ this.getLaunchTemplate() == null) {
            return false;
        }
        if (other.getLaunchTemplate() != null && !other.getLaunchTemplate().equals(this.getLaunchTemplate())) {
            return false;
        }
        if (other.getUpdateConfig() == null ^ this.getUpdateConfig() == null) {
            return false;
        }
        if (other.getUpdateConfig() != null && !other.getUpdateConfig().equals(this.getUpdateConfig())) {
            return false;
        }
        if (other.getCapacityType() == null ^ this.getCapacityType() == null) {
            return false;
        }
        if (other.getCapacityType() != null && !other.getCapacityType().equals(this.getCapacityType())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getReleaseVersion() == null ^ this.getReleaseVersion() == null) {
            return false;
        }
        return other.getReleaseVersion() == null || other.getReleaseVersion().equals(this.getReleaseVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getNodegroupName() == null ? 0 : this.getNodegroupName().hashCode());
        hashCode = 31 * hashCode + (this.getScalingConfig() == null ? 0 : this.getScalingConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDiskSize() == null ? 0 : this.getDiskSize().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTypes() == null ? 0 : this.getInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getAmiType() == null ? 0 : this.getAmiType().hashCode());
        hashCode = 31 * hashCode + (this.getRemoteAccess() == null ? 0 : this.getRemoteAccess().hashCode());
        hashCode = 31 * hashCode + (this.getNodeRole() == null ? 0 : this.getNodeRole().hashCode());
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        hashCode = 31 * hashCode + (this.getTaints() == null ? 0 : this.getTaints().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTemplate() == null ? 0 : this.getLaunchTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateConfig() == null ? 0 : this.getUpdateConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCapacityType() == null ? 0 : this.getCapacityType().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseVersion() == null ? 0 : this.getReleaseVersion().hashCode());
        return hashCode;
    }

    public CreateNodegroupRequest clone() {
        return (CreateNodegroupRequest)super.clone();
    }
}

