/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.CacheCluster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeCacheClustersResult
implements Serializable {
    private String marker;
    private ListWithAutoConstructFlag<CacheCluster> cacheClusters;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeCacheClustersResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<CacheCluster> getCacheClusters() {
        if (this.cacheClusters == null) {
            this.cacheClusters = new ListWithAutoConstructFlag();
            this.cacheClusters.setAutoConstruct(true);
        }
        return this.cacheClusters;
    }

    public void setCacheClusters(Collection<CacheCluster> cacheClusters) {
        if (cacheClusters == null) {
            this.cacheClusters = null;
            return;
        }
        ListWithAutoConstructFlag cacheClustersCopy = new ListWithAutoConstructFlag(cacheClusters.size());
        cacheClustersCopy.addAll(cacheClusters);
        this.cacheClusters = cacheClustersCopy;
    }

    public DescribeCacheClustersResult withCacheClusters(CacheCluster ... cacheClusters) {
        if (this.getCacheClusters() == null) {
            this.setCacheClusters(new ArrayList<CacheCluster>(cacheClusters.length));
        }
        for (CacheCluster value : cacheClusters) {
            this.getCacheClusters().add(value);
        }
        return this;
    }

    public DescribeCacheClustersResult withCacheClusters(Collection<CacheCluster> cacheClusters) {
        if (cacheClusters == null) {
            this.cacheClusters = null;
        } else {
            ListWithAutoConstructFlag cacheClustersCopy = new ListWithAutoConstructFlag(cacheClusters.size());
            cacheClustersCopy.addAll(cacheClusters);
            this.cacheClusters = cacheClustersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getCacheClusters() != null) {
            sb.append("CacheClusters: " + this.getCacheClusters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusters() == null ? 0 : this.getCacheClusters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheClustersResult)) {
            return false;
        }
        DescribeCacheClustersResult other = (DescribeCacheClustersResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getCacheClusters() == null ^ this.getCacheClusters() == null) {
            return false;
        }
        return other.getCacheClusters() == null || other.getCacheClusters().equals(this.getCacheClusters());
    }
}

