/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.CacheNodeTypeSpecificParameter;
import com.amazonaws.services.elasticache.model.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EngineDefaults
implements Serializable {
    private String cacheParameterGroupFamily;
    private String marker;
    private ListWithAutoConstructFlag<Parameter> parameters;
    private ListWithAutoConstructFlag<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters;

    public String getCacheParameterGroupFamily() {
        return this.cacheParameterGroupFamily;
    }

    public void setCacheParameterGroupFamily(String cacheParameterGroupFamily) {
        this.cacheParameterGroupFamily = cacheParameterGroupFamily;
    }

    public EngineDefaults withCacheParameterGroupFamily(String cacheParameterGroupFamily) {
        this.cacheParameterGroupFamily = cacheParameterGroupFamily;
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public EngineDefaults withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ListWithAutoConstructFlag();
            this.parameters.setAutoConstruct(true);
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public EngineDefaults withParameters(Parameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<Parameter>(parameters.length));
        }
        for (Parameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public EngineDefaults withParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public List<CacheNodeTypeSpecificParameter> getCacheNodeTypeSpecificParameters() {
        if (this.cacheNodeTypeSpecificParameters == null) {
            this.cacheNodeTypeSpecificParameters = new ListWithAutoConstructFlag();
            this.cacheNodeTypeSpecificParameters.setAutoConstruct(true);
        }
        return this.cacheNodeTypeSpecificParameters;
    }

    public void setCacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters) {
        if (cacheNodeTypeSpecificParameters == null) {
            this.cacheNodeTypeSpecificParameters = null;
            return;
        }
        ListWithAutoConstructFlag cacheNodeTypeSpecificParametersCopy = new ListWithAutoConstructFlag(cacheNodeTypeSpecificParameters.size());
        cacheNodeTypeSpecificParametersCopy.addAll(cacheNodeTypeSpecificParameters);
        this.cacheNodeTypeSpecificParameters = cacheNodeTypeSpecificParametersCopy;
    }

    public EngineDefaults withCacheNodeTypeSpecificParameters(CacheNodeTypeSpecificParameter ... cacheNodeTypeSpecificParameters) {
        if (this.getCacheNodeTypeSpecificParameters() == null) {
            this.setCacheNodeTypeSpecificParameters(new ArrayList<CacheNodeTypeSpecificParameter>(cacheNodeTypeSpecificParameters.length));
        }
        for (CacheNodeTypeSpecificParameter value : cacheNodeTypeSpecificParameters) {
            this.getCacheNodeTypeSpecificParameters().add(value);
        }
        return this;
    }

    public EngineDefaults withCacheNodeTypeSpecificParameters(Collection<CacheNodeTypeSpecificParameter> cacheNodeTypeSpecificParameters) {
        if (cacheNodeTypeSpecificParameters == null) {
            this.cacheNodeTypeSpecificParameters = null;
        } else {
            ListWithAutoConstructFlag cacheNodeTypeSpecificParametersCopy = new ListWithAutoConstructFlag(cacheNodeTypeSpecificParameters.size());
            cacheNodeTypeSpecificParametersCopy.addAll(cacheNodeTypeSpecificParameters);
            this.cacheNodeTypeSpecificParameters = cacheNodeTypeSpecificParametersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheParameterGroupFamily() != null) {
            sb.append("CacheParameterGroupFamily: " + this.getCacheParameterGroupFamily() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters() + ",");
        }
        if (this.getCacheNodeTypeSpecificParameters() != null) {
            sb.append("CacheNodeTypeSpecificParameters: " + this.getCacheNodeTypeSpecificParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheParameterGroupFamily() == null ? 0 : this.getCacheParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeTypeSpecificParameters() == null ? 0 : this.getCacheNodeTypeSpecificParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineDefaults)) {
            return false;
        }
        EngineDefaults other = (EngineDefaults)obj;
        if (other.getCacheParameterGroupFamily() == null ^ this.getCacheParameterGroupFamily() == null) {
            return false;
        }
        if (other.getCacheParameterGroupFamily() != null && !other.getCacheParameterGroupFamily().equals(this.getCacheParameterGroupFamily())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getCacheNodeTypeSpecificParameters() == null ^ this.getCacheNodeTypeSpecificParameters() == null) {
            return false;
        }
        return other.getCacheNodeTypeSpecificParameters() == null || other.getCacheNodeTypeSpecificParameters().equals(this.getCacheNodeTypeSpecificParameters());
    }
}

