/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.ClusterState;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ListClustersRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Date createdAfter;
    private Date createdBefore;
    private SdkInternalList<String> clusterStates;
    private String marker;

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public ListClustersRequest withCreatedAfter(Date createdAfter) {
        this.setCreatedAfter(createdAfter);
        return this;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public ListClustersRequest withCreatedBefore(Date createdBefore) {
        this.setCreatedBefore(createdBefore);
        return this;
    }

    public List<String> getClusterStates() {
        if (this.clusterStates == null) {
            this.clusterStates = new SdkInternalList();
        }
        return this.clusterStates;
    }

    public void setClusterStates(Collection<String> clusterStates) {
        if (clusterStates == null) {
            this.clusterStates = null;
            return;
        }
        this.clusterStates = new SdkInternalList(clusterStates);
    }

    public ListClustersRequest withClusterStates(String ... clusterStates) {
        if (this.clusterStates == null) {
            this.setClusterStates((Collection<String>)new SdkInternalList(clusterStates.length));
        }
        for (String ele : clusterStates) {
            this.clusterStates.add((Object)ele);
        }
        return this;
    }

    public ListClustersRequest withClusterStates(Collection<String> clusterStates) {
        this.setClusterStates(clusterStates);
        return this;
    }

    public ListClustersRequest withClusterStates(ClusterState ... clusterStates) {
        SdkInternalList clusterStatesCopy = new SdkInternalList(clusterStates.length);
        for (ClusterState value : clusterStates) {
            clusterStatesCopy.add((Object)value.toString());
        }
        if (this.getClusterStates() == null) {
            this.setClusterStates((Collection<String>)clusterStatesCopy);
        } else {
            this.getClusterStates().addAll((Collection<String>)clusterStatesCopy);
        }
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListClustersRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreatedAfter() != null) {
            sb.append("CreatedAfter: " + this.getCreatedAfter() + ",");
        }
        if (this.getCreatedBefore() != null) {
            sb.append("CreatedBefore: " + this.getCreatedBefore() + ",");
        }
        if (this.getClusterStates() != null) {
            sb.append("ClusterStates: " + this.getClusterStates() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest)obj;
        if (other.getCreatedAfter() == null ^ this.getCreatedAfter() == null) {
            return false;
        }
        if (other.getCreatedAfter() != null && !other.getCreatedAfter().equals(this.getCreatedAfter())) {
            return false;
        }
        if (other.getCreatedBefore() == null ^ this.getCreatedBefore() == null) {
            return false;
        }
        if (other.getCreatedBefore() != null && !other.getCreatedBefore().equals(this.getCreatedBefore())) {
            return false;
        }
        if (other.getClusterStates() == null ^ this.getClusterStates() == null) {
            return false;
        }
        if (other.getClusterStates() != null && !other.getClusterStates().equals(this.getClusterStates())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreatedAfter() == null ? 0 : this.getCreatedAfter().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBefore() == null ? 0 : this.getCreatedBefore().hashCode());
        hashCode = 31 * hashCode + (this.getClusterStates() == null ? 0 : this.getClusterStates().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListClustersRequest clone() {
        return (ListClustersRequest)super.clone();
    }
}

