/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.ClusterSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListClustersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<ClusterSummary> clusters;
    private String marker;

    public List<ClusterSummary> getClusters() {
        if (this.clusters == null) {
            this.clusters = new SdkInternalList();
        }
        return this.clusters;
    }

    public void setClusters(Collection<ClusterSummary> clusters) {
        if (clusters == null) {
            this.clusters = null;
            return;
        }
        this.clusters = new SdkInternalList(clusters);
    }

    public ListClustersResult withClusters(ClusterSummary ... clusters) {
        if (this.clusters == null) {
            this.setClusters((Collection<ClusterSummary>)new SdkInternalList(clusters.length));
        }
        for (ClusterSummary ele : clusters) {
            this.clusters.add((Object)ele);
        }
        return this;
    }

    public ListClustersResult withClusters(Collection<ClusterSummary> clusters) {
        this.setClusters(clusters);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListClustersResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusters() != null) {
            sb.append("Clusters: " + this.getClusters() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResult)) {
            return false;
        }
        ListClustersResult other = (ListClustersResult)obj;
        if (other.getClusters() == null ^ this.getClusters() == null) {
            return false;
        }
        if (other.getClusters() != null && !other.getClusters().equals(this.getClusters())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusters() == null ? 0 : this.getClusters().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListClustersResult clone() {
        try {
            return (ListClustersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

