/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.fis.model.ExperimentTarget;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ExperimentTargetMarshaller {
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<List> RESOURCEARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceArns").build();
    private static final MarshallingInfo<Map> RESOURCETAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceTags").build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filters").build();
    private static final MarshallingInfo<String> SELECTIONMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("selectionMode").build();
    private static final ExperimentTargetMarshaller instance = new ExperimentTargetMarshaller();

    public static ExperimentTargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExperimentTarget experimentTarget, ProtocolMarshaller protocolMarshaller) {
        if (experimentTarget == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)experimentTarget.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(experimentTarget.getResourceArns(), RESOURCEARNS_BINDING);
            protocolMarshaller.marshall(experimentTarget.getResourceTags(), RESOURCETAGS_BINDING);
            protocolMarshaller.marshall(experimentTarget.getFilters(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)experimentTarget.getSelectionMode(), SELECTIONMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

