/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.ExperimentTemplate;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ExperimentTemplateMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Map> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").build();
    private static final MarshallingInfo<Map> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").build();
    private static final MarshallingInfo<List> STOPCONDITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopConditions").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<StructuredPojo> LOGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logConfiguration").build();
    private static final ExperimentTemplateMarshaller instance = new ExperimentTemplateMarshaller();

    public static ExperimentTemplateMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExperimentTemplate experimentTemplate, ProtocolMarshaller protocolMarshaller) {
        if (experimentTemplate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)experimentTemplate.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)experimentTemplate.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(experimentTemplate.getTargets(), TARGETS_BINDING);
            protocolMarshaller.marshall(experimentTemplate.getActions(), ACTIONS_BINDING);
            protocolMarshaller.marshall(experimentTemplate.getStopConditions(), STOPCONDITIONS_BINDING);
            protocolMarshaller.marshall((Object)experimentTemplate.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)experimentTemplate.getLastUpdateTime(), LASTUPDATETIME_BINDING);
            protocolMarshaller.marshall((Object)experimentTemplate.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(experimentTemplate.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)experimentTemplate.getLogConfiguration(), LOGCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

