/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.fms.model.App;

@SdkInternalApi
public class AppMarshaller {
    private static final MarshallingInfo<String> APPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppName").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Protocol").build();
    private static final MarshallingInfo<Long> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").build();
    private static final AppMarshaller instance = new AppMarshaller();

    public static AppMarshaller getInstance() {
        return instance;
    }

    public void marshall(App app, ProtocolMarshaller protocolMarshaller) {
        if (app == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)app.getAppName(), APPNAME_BINDING);
            protocolMarshaller.marshall((Object)app.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)app.getPort(), PORT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

