/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.forecast.model.PredictorSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPredictorsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PredictorSummary> predictors;
    private String nextToken;

    public List<PredictorSummary> getPredictors() {
        return this.predictors;
    }

    public void setPredictors(Collection<PredictorSummary> predictors) {
        if (predictors == null) {
            this.predictors = null;
            return;
        }
        this.predictors = new ArrayList<PredictorSummary>(predictors);
    }

    public ListPredictorsResult withPredictors(PredictorSummary ... predictors) {
        if (this.predictors == null) {
            this.setPredictors(new ArrayList<PredictorSummary>(predictors.length));
        }
        for (PredictorSummary ele : predictors) {
            this.predictors.add(ele);
        }
        return this;
    }

    public ListPredictorsResult withPredictors(Collection<PredictorSummary> predictors) {
        this.setPredictors(predictors);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPredictorsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPredictors() != null) {
            sb.append("Predictors: ").append(this.getPredictors()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPredictorsResult)) {
            return false;
        }
        ListPredictorsResult other = (ListPredictorsResult)obj;
        if (other.getPredictors() == null ^ this.getPredictors() == null) {
            return false;
        }
        if (other.getPredictors() != null && !other.getPredictors().equals(this.getPredictors())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPredictors() == null ? 0 : this.getPredictors().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPredictorsResult clone() {
        try {
            return (ListPredictorsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

