/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fsx.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.fsx.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeleteFileSystemResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteFileSystemResultJsonUnmarshaller implements Unmarshaller<DeleteFileSystemResult, JsonUnmarshallerContext> {

    public DeleteFileSystemResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeleteFileSystemResult deleteFileSystemResult = new DeleteFileSystemResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return deleteFileSystemResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("FileSystemId", targetDepth)) {
                    context.nextToken();
                    deleteFileSystemResult.setFileSystemId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Lifecycle", targetDepth)) {
                    context.nextToken();
                    deleteFileSystemResult.setLifecycle(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WindowsResponse", targetDepth)) {
                    context.nextToken();
                    deleteFileSystemResult.setWindowsResponse(DeleteFileSystemWindowsResponseJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LustreResponse", targetDepth)) {
                    context.nextToken();
                    deleteFileSystemResult.setLustreResponse(DeleteFileSystemLustreResponseJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("OpenZFSResponse", targetDepth)) {
                    context.nextToken();
                    deleteFileSystemResult.setOpenZFSResponse(DeleteFileSystemOpenZFSResponseJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return deleteFileSystemResult;
    }

    private static DeleteFileSystemResultJsonUnmarshaller instance;

    public static DeleteFileSystemResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DeleteFileSystemResultJsonUnmarshaller();
        return instance;
    }
}
