/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.Snapshot;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class SnapshotMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").build();
    private static final MarshallingInfo<String> SNAPSHOTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> VOLUMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeId").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> LIFECYCLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lifecycle").build();
    private static final MarshallingInfo<StructuredPojo> LIFECYCLETRANSITIONREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifecycleTransitionReason").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<List> ADMINISTRATIVEACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdministrativeActions").build();
    private static final SnapshotMarshaller instance = new SnapshotMarshaller();

    public static SnapshotMarshaller getInstance() {
        return instance;
    }

    public void marshall(Snapshot snapshot, ProtocolMarshaller protocolMarshaller) {
        if (snapshot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)snapshot.getResourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotId(), SNAPSHOTID_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getVolumeId(), VOLUMEID_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getLifecycle(), LIFECYCLE_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getLifecycleTransitionReason(), LIFECYCLETRANSITIONREASON_BINDING);
            protocolMarshaller.marshall(snapshot.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(snapshot.getAdministrativeActions(), ADMINISTRATIVEACTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

