/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.AdministrativeAction;
import com.amazonaws.services.fsx.model.LifecycleTransitionReason;
import com.amazonaws.services.fsx.model.SnapshotLifecycle;
import com.amazonaws.services.fsx.model.Tag;
import com.amazonaws.services.fsx.model.transform.SnapshotMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Snapshot
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceARN;
    private String snapshotId;
    private String name;
    private String volumeId;
    private Date creationTime;
    private String lifecycle;
    private LifecycleTransitionReason lifecycleTransitionReason;
    private List<Tag> tags;
    private List<AdministrativeAction> administrativeActions;

    public void setResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
    }

    public String getResourceARN() {
        return this.resourceARN;
    }

    public Snapshot withResourceARN(String resourceARN) {
        this.setResourceARN(resourceARN);
        return this;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public Snapshot withSnapshotId(String snapshotId) {
        this.setSnapshotId(snapshotId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Snapshot withName(String name) {
        this.setName(name);
        return this;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public Snapshot withVolumeId(String volumeId) {
        this.setVolumeId(volumeId);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Snapshot withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLifecycle(String lifecycle) {
        this.lifecycle = lifecycle;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public Snapshot withLifecycle(String lifecycle) {
        this.setLifecycle(lifecycle);
        return this;
    }

    public Snapshot withLifecycle(SnapshotLifecycle lifecycle) {
        this.lifecycle = lifecycle.toString();
        return this;
    }

    public void setLifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason) {
        this.lifecycleTransitionReason = lifecycleTransitionReason;
    }

    public LifecycleTransitionReason getLifecycleTransitionReason() {
        return this.lifecycleTransitionReason;
    }

    public Snapshot withLifecycleTransitionReason(LifecycleTransitionReason lifecycleTransitionReason) {
        this.setLifecycleTransitionReason(lifecycleTransitionReason);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Snapshot withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Snapshot withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<AdministrativeAction> getAdministrativeActions() {
        return this.administrativeActions;
    }

    public void setAdministrativeActions(Collection<AdministrativeAction> administrativeActions) {
        if (administrativeActions == null) {
            this.administrativeActions = null;
            return;
        }
        this.administrativeActions = new ArrayList<AdministrativeAction>(administrativeActions);
    }

    public Snapshot withAdministrativeActions(AdministrativeAction ... administrativeActions) {
        if (this.administrativeActions == null) {
            this.setAdministrativeActions(new ArrayList<AdministrativeAction>(administrativeActions.length));
        }
        for (AdministrativeAction ele : administrativeActions) {
            this.administrativeActions.add(ele);
        }
        return this;
    }

    public Snapshot withAdministrativeActions(Collection<AdministrativeAction> administrativeActions) {
        this.setAdministrativeActions(administrativeActions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceARN() != null) {
            sb.append("ResourceARN: ").append(this.getResourceARN()).append(",");
        }
        if (this.getSnapshotId() != null) {
            sb.append("SnapshotId: ").append(this.getSnapshotId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getVolumeId() != null) {
            sb.append("VolumeId: ").append(this.getVolumeId()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLifecycle() != null) {
            sb.append("Lifecycle: ").append(this.getLifecycle()).append(",");
        }
        if (this.getLifecycleTransitionReason() != null) {
            sb.append("LifecycleTransitionReason: ").append(this.getLifecycleTransitionReason()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAdministrativeActions() != null) {
            sb.append("AdministrativeActions: ").append(this.getAdministrativeActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        if (other.getResourceARN() == null ^ this.getResourceARN() == null) {
            return false;
        }
        if (other.getResourceARN() != null && !other.getResourceARN().equals(this.getResourceARN())) {
            return false;
        }
        if (other.getSnapshotId() == null ^ this.getSnapshotId() == null) {
            return false;
        }
        if (other.getSnapshotId() != null && !other.getSnapshotId().equals(this.getSnapshotId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVolumeId() == null ^ this.getVolumeId() == null) {
            return false;
        }
        if (other.getVolumeId() != null && !other.getVolumeId().equals(this.getVolumeId())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLifecycle() == null ^ this.getLifecycle() == null) {
            return false;
        }
        if (other.getLifecycle() != null && !other.getLifecycle().equals(this.getLifecycle())) {
            return false;
        }
        if (other.getLifecycleTransitionReason() == null ^ this.getLifecycleTransitionReason() == null) {
            return false;
        }
        if (other.getLifecycleTransitionReason() != null && !other.getLifecycleTransitionReason().equals(this.getLifecycleTransitionReason())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAdministrativeActions() == null ^ this.getAdministrativeActions() == null) {
            return false;
        }
        return other.getAdministrativeActions() == null || other.getAdministrativeActions().equals(this.getAdministrativeActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceARN() == null ? 0 : this.getResourceARN().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotId() == null ? 0 : this.getSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeId() == null ? 0 : this.getVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycle() == null ? 0 : this.getLifecycle().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycleTransitionReason() == null ? 0 : this.getLifecycleTransitionReason().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAdministrativeActions() == null ? 0 : this.getAdministrativeActions().hashCode());
        return hashCode;
    }

    public Snapshot clone() {
        try {
            return (Snapshot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

