/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.UpdateGameSessionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateGameSessionRequestMarshaller
implements Marshaller<Request<UpdateGameSessionRequest>, UpdateGameSessionRequest> {
    public Request<UpdateGameSessionRequest> marshall(UpdateGameSessionRequest updateGameSessionRequest) {
        if (updateGameSessionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateGameSessionRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateGameSession");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (updateGameSessionRequest.getGameSessionId() != null) {
                jsonGenerator.writeFieldName("GameSessionId").writeValue(updateGameSessionRequest.getGameSessionId());
            }
            if (updateGameSessionRequest.getMaximumPlayerSessionCount() != null) {
                jsonGenerator.writeFieldName("MaximumPlayerSessionCount").writeValue(updateGameSessionRequest.getMaximumPlayerSessionCount().intValue());
            }
            if (updateGameSessionRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateGameSessionRequest.getName());
            }
            if (updateGameSessionRequest.getPlayerSessionCreationPolicy() != null) {
                jsonGenerator.writeFieldName("PlayerSessionCreationPolicy").writeValue(updateGameSessionRequest.getPlayerSessionCreationPolicy());
            }
            if (updateGameSessionRequest.getProtectionPolicy() != null) {
                jsonGenerator.writeFieldName("ProtectionPolicy").writeValue(updateGameSessionRequest.getProtectionPolicy());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

