/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.PriorityType;
import com.amazonaws.services.gamelift.model.transform.PriorityConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PriorityConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> priorityOrder;
    private List<String> locationOrder;

    public List<String> getPriorityOrder() {
        return this.priorityOrder;
    }

    public void setPriorityOrder(Collection<String> priorityOrder) {
        if (priorityOrder == null) {
            this.priorityOrder = null;
            return;
        }
        this.priorityOrder = new ArrayList<String>(priorityOrder);
    }

    public PriorityConfiguration withPriorityOrder(String ... priorityOrder) {
        if (this.priorityOrder == null) {
            this.setPriorityOrder(new ArrayList<String>(priorityOrder.length));
        }
        for (String ele : priorityOrder) {
            this.priorityOrder.add(ele);
        }
        return this;
    }

    public PriorityConfiguration withPriorityOrder(Collection<String> priorityOrder) {
        this.setPriorityOrder(priorityOrder);
        return this;
    }

    public PriorityConfiguration withPriorityOrder(PriorityType ... priorityOrder) {
        ArrayList<String> priorityOrderCopy = new ArrayList<String>(priorityOrder.length);
        for (PriorityType value : priorityOrder) {
            priorityOrderCopy.add(value.toString());
        }
        if (this.getPriorityOrder() == null) {
            this.setPriorityOrder(priorityOrderCopy);
        } else {
            this.getPriorityOrder().addAll(priorityOrderCopy);
        }
        return this;
    }

    public List<String> getLocationOrder() {
        return this.locationOrder;
    }

    public void setLocationOrder(Collection<String> locationOrder) {
        if (locationOrder == null) {
            this.locationOrder = null;
            return;
        }
        this.locationOrder = new ArrayList<String>(locationOrder);
    }

    public PriorityConfiguration withLocationOrder(String ... locationOrder) {
        if (this.locationOrder == null) {
            this.setLocationOrder(new ArrayList<String>(locationOrder.length));
        }
        for (String ele : locationOrder) {
            this.locationOrder.add(ele);
        }
        return this;
    }

    public PriorityConfiguration withLocationOrder(Collection<String> locationOrder) {
        this.setLocationOrder(locationOrder);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPriorityOrder() != null) {
            sb.append("PriorityOrder: ").append(this.getPriorityOrder()).append(",");
        }
        if (this.getLocationOrder() != null) {
            sb.append("LocationOrder: ").append(this.getLocationOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriorityConfiguration)) {
            return false;
        }
        PriorityConfiguration other = (PriorityConfiguration)obj;
        if (other.getPriorityOrder() == null ^ this.getPriorityOrder() == null) {
            return false;
        }
        if (other.getPriorityOrder() != null && !other.getPriorityOrder().equals(this.getPriorityOrder())) {
            return false;
        }
        if (other.getLocationOrder() == null ^ this.getLocationOrder() == null) {
            return false;
        }
        return other.getLocationOrder() == null || other.getLocationOrder().equals(this.getLocationOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPriorityOrder() == null ? 0 : this.getPriorityOrder().hashCode());
        hashCode = 31 * hashCode + (this.getLocationOrder() == null ? 0 : this.getLocationOrder().hashCode());
        return hashCode;
    }

    public PriorityConfiguration clone() {
        try {
            return (PriorityConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PriorityConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

